/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webdav.servlet.shared;

import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import org.bedework.access.AccessPrincipal;
import org.bedework.access.CurrentAccess;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.tagdefs.AppleServerTags;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.bedework.webdav.servlet.shared.UrlHandler;
import org.bedework.webdav.servlet.shared.WdCollection;
import org.bedework.webdav.servlet.shared.WdEntity;
import org.bedework.webdav.servlet.shared.WdSysIntf;
import org.bedework.webdav.servlet.shared.WebdavNsIntf;
import org.bedework.webdav.servlet.shared.WebdavNsNode;
import org.w3c.dom.Element;

public class WebdavPrincipalNode
extends WebdavNsNode {
    private final AccessPrincipal account;
    private static final HashMap<QName, WebdavNsNode.PropertyTagEntry> propertyNames = new HashMap();
    private final BwLogger logger = new BwLogger();

    public WebdavPrincipalNode(WdSysIntf sysi, UrlHandler urlHandler, String path, AccessPrincipal account, boolean collection, String uri) {
        super(sysi, urlHandler, path, collection, uri);
        this.account = account;
        this.userPrincipal = account.getKind() == 1;
        this.groupPrincipal = account.getKind() == 2;
    }

    @Override
    public AccessPrincipal getOwner() {
        return this.account;
    }

    @Override
    public void update() {
    }

    @Override
    public CurrentAccess getCurrentAccess() {
        return null;
    }

    @Override
    public String getEtagValue(boolean strong) {
        String val = "1234567890";
        if (strong) {
            return "\"1234567890\"";
        }
        return "W/\"1234567890\"";
    }

    @Override
    public boolean trailSlash() {
        return true;
    }

    @Override
    public Collection<? extends WdEntity<?>> getChildren(Supplier<Object> filterGetter) {
        return null;
    }

    @Override
    public WdCollection<?> getCollection(boolean deref) {
        return null;
    }

    @Override
    public WdCollection<?> getImmediateTargetCollection() {
        return null;
    }

    @Override
    public boolean allowsSyncReport() {
        return false;
    }

    @Override
    public boolean getDeleted() {
        return false;
    }

    @Override
    public String getSyncToken() {
        return null;
    }

    @Override
    public String writeContent(XmlEmit xml, Writer wtr, String contentType) {
        return null;
    }

    @Override
    public boolean getContentBinary() {
        return false;
    }

    @Override
    public String getContentLang() {
        return null;
    }

    @Override
    public long getContentLen() {
        return 0L;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public String getCreDate() {
        return null;
    }

    @Override
    public String getDisplayname() {
        return this.account.getAccount();
    }

    @Override
    public String getLastmodDate() {
        return null;
    }

    @Override
    public boolean removeProperty(Element val, WebdavNsNode.SetPropertyResult spr) {
        this.warn("Unimplemented - removeProperty");
        return false;
    }

    @Override
    public boolean setProperty(Element val, WebdavNsNode.SetPropertyResult spr) {
        return super.setProperty(val, spr);
    }

    @Override
    public boolean knownProperty(QName tag) {
        if (propertyNames.get(tag) != null) {
            return true;
        }
        return super.knownProperty(tag);
    }

    @Override
    public boolean generatePropertyValue(QName tag, WebdavNsIntf intf, boolean allProp) {
        String ns = tag.getNamespaceURI();
        XmlEmit xml = intf.getXmlEmit();
        if (tag.equals(WebdavTags.groupMemberSet)) {
            xml.emptyTag(tag);
            return true;
        }
        if (tag.equals(WebdavTags.groupMembership)) {
            xml.emptyTag(tag);
            return true;
        }
        if (tag.equals(WebdavTags.notificationURL) || tag.equals(AppleServerTags.notificationURL)) {
            if (this.wdSysIntf.getNotificationURL() == null) {
                return false;
            }
            xml.openTag(tag);
            this.generateHref(xml, this.wdSysIntf.getNotificationURL());
            xml.closeTag(tag);
            return true;
        }
        return super.generatePropertyValue(tag, intf, allProp);
    }

    @Override
    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    static {
        WebdavPrincipalNode.addPropEntry(propertyNames, WebdavTags.groupMemberSet);
        WebdavPrincipalNode.addPropEntry(propertyNames, WebdavTags.groupMembership);
        WebdavPrincipalNode.addPropEntry(propertyNames, WebdavTags.notificationURL);
        WebdavPrincipalNode.addPropEntry(propertyNames, AppleServerTags.notificationURL);
    }
}

