
package ietf.params.xml.ns.icalendar_2;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;


/**
 * 
 *         From RFC 5545 Section 3.6.2
 *        todoc      = "BEGIN" ":" "VTODO" CRLF
 *                     todoprop *alarmc
 *                     "END" ":" "VTODO" CRLF
 * 
 *        todoprop   = *(
 *                   ;
 *                   ; The following are REQUIRED,
 *                   ; but MUST NOT occur more than once.
 *                   ;
 *                   dtstamp / uid /
 *                   ;
 *                   ; The following are OPTIONAL,
 *                   ; but MUST NOT occur more than once.
 *                   ;
 *                   class / completed / created / description /
 *                   dtstart / geo / last-mod / location / organizer /
 *                   percent / priority / recurid / seq / status /
 *                   summary / url /
 *                   ;
 *                   ; The following is OPTIONAL,
 *                   ; but SHOULD NOT occur more than once.
 *                   ;
 *                   rrule /
 *                   ;
 *                   ; Either 'due' or 'duration' MAY appear in
 *                   ; a 'todoprop', but 'due' and 'duration'
 *                   ; MUST NOT occur in the same 'todoprop'.
 *                   ; If 'duration' appear in a 'todoprop',
 *                   ; then 'dtstart' MUST also appear in
 *                   ; the same 'todoprop'.
 *                   ;
 *                   due / duration /
 *                   ;
 *                   ; The following are OPTIONAL,
 *                   ; and MAY occur more than once.
 *                   ;
 *                   attach / attendee / categories / comment / contact /
 *                   exdate / rstatus / related / resources /
 *                   rdate / x-prop / iana-prop
 *                   ;
 *                   )
 *       
 * 
 * <p>Java class for ArrayOfTodoContainedProperties complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ArrayOfTodoContainedProperties"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;choice maxOccurs="unbounded" minOccurs="0"&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}dtstamp"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}uid"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}class"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}completed"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}created"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}description"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}dtstart"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}geo"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}last-modified"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}location"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}organizer"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}percent-complete"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}priority"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}recurrence-id"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}sequence"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}status"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}summary"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}url"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}rrule"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}exrule"/&gt;
 *           &lt;choice&gt;
 *             &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}due"/&gt;
 *             &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}duration"/&gt;
 *           &lt;/choice&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}attach"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}attendee"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}categories"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}comment"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}contact"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}exdate"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}request-status"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}related"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}resources"/&gt;
 *           &lt;element ref="{urn:ietf:params:xml:ns:icalendar-2.0}rdate"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ArrayOfTodoContainedProperties", propOrder = {
    "dtstampOrUidOrClazz"
})
public class ArrayOfTodoContainedProperties {

    @XmlElements({
        @XmlElement(name = "dtstamp", type = DtstampPropType.class),
        @XmlElement(name = "uid", type = UidPropType.class),
        @XmlElement(name = "class", type = ClassPropType.class),
        @XmlElement(name = "completed", type = CompletedPropType.class),
        @XmlElement(name = "created", type = CreatedPropType.class),
        @XmlElement(name = "description", type = DescriptionPropType.class),
        @XmlElement(name = "dtstart", type = DtstartPropType.class),
        @XmlElement(name = "geo", type = GeoPropType.class),
        @XmlElement(name = "last-modified", type = LastModifiedPropType.class),
        @XmlElement(name = "location", type = LocationPropType.class),
        @XmlElement(name = "organizer", type = OrganizerPropType.class),
        @XmlElement(name = "percent-complete", type = PercentCompletePropType.class),
        @XmlElement(name = "priority", type = PriorityPropType.class),
        @XmlElement(name = "recurrence-id", type = RecurrenceIdPropType.class),
        @XmlElement(name = "sequence", type = SequencePropType.class),
        @XmlElement(name = "status", type = StatusPropType.class),
        @XmlElement(name = "summary", type = SummaryPropType.class),
        @XmlElement(name = "url", type = UrlPropType.class),
        @XmlElement(name = "rrule", type = RrulePropType.class),
        @XmlElement(name = "exrule", type = ExrulePropType.class),
        @XmlElement(name = "due", type = DuePropType.class),
        @XmlElement(name = "duration", type = DurationPropType.class),
        @XmlElement(name = "attach", type = AttachPropType.class),
        @XmlElement(name = "attendee", type = AttendeePropType.class),
        @XmlElement(name = "categories", type = CategoriesPropType.class),
        @XmlElement(name = "comment", type = CommentPropType.class),
        @XmlElement(name = "contact", type = ContactPropType.class),
        @XmlElement(name = "exdate", type = ExdatePropType.class),
        @XmlElement(name = "request-status", type = RequestStatusPropType.class),
        @XmlElement(name = "related", type = RelatedParamType.class),
        @XmlElement(name = "resources", type = ResourcesPropType.class),
        @XmlElement(name = "rdate", type = RdatePropType.class)
    })
    protected List<Object> dtstampOrUidOrClazz;

    /**
     * Gets the value of the dtstampOrUidOrClazz property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dtstampOrUidOrClazz property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDtstampOrUidOrClazz().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DtstampPropType }
     * {@link UidPropType }
     * {@link ClassPropType }
     * {@link CompletedPropType }
     * {@link CreatedPropType }
     * {@link DescriptionPropType }
     * {@link DtstartPropType }
     * {@link GeoPropType }
     * {@link LastModifiedPropType }
     * {@link LocationPropType }
     * {@link OrganizerPropType }
     * {@link PercentCompletePropType }
     * {@link PriorityPropType }
     * {@link RecurrenceIdPropType }
     * {@link SequencePropType }
     * {@link StatusPropType }
     * {@link SummaryPropType }
     * {@link UrlPropType }
     * {@link RrulePropType }
     * {@link ExrulePropType }
     * {@link DuePropType }
     * {@link DurationPropType }
     * {@link AttachPropType }
     * {@link AttendeePropType }
     * {@link CategoriesPropType }
     * {@link CommentPropType }
     * {@link ContactPropType }
     * {@link ExdatePropType }
     * {@link RequestStatusPropType }
     * {@link RelatedParamType }
     * {@link ResourcesPropType }
     * {@link RdatePropType }
     * 
     * 
     */
    public List<Object> getDtstampOrUidOrClazz() {
        if (dtstampOrUidOrClazz == null) {
            dtstampOrUidOrClazz = new ArrayList<Object>();
        }
        return this.dtstampOrUidOrClazz;
    }

}
