/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify;

import java.math.BigInteger;
import java.util.Random;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.beryx.streamplify.Splittable;
import org.beryx.streamplify.Streamable;
import org.beryx.streamplify.permutation.LongPermutations;
import org.beryx.streamplify.shuffler.BigIntegerShuffler;
import org.beryx.streamplify.shuffler.DefaultBigIntegerShuffler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigIntegerIndexedSpliterator<T, S extends BigIntegerIndexedSpliterator<T, S>>
implements Spliterator<T>,
Streamable<T, S> {
    private static final Logger logger = LoggerFactory.getLogger(LongPermutations.class);
    private Splittable.BigIntegerIndexed<T> valueSupplier;
    private BigInteger index;
    private final BigInteger fence;
    int characteristics = 1024;
    private BigIntegerShuffler shuffler = BigIntegerShuffler.IDENTITY;

    protected BigIntegerIndexedSpliterator(BigInteger origin, BigInteger fence) {
        logger.trace("BigIntegerIndexedSpliterator({}, {})", (Object)origin, (Object)fence);
        if (origin.compareTo(BigInteger.ZERO) < 0 || fence.compareTo(origin) < 0) {
            throw new IllegalArgumentException("origin: " + origin + ", fence: " + fence);
        }
        this.index = origin;
        this.fence = fence;
    }

    @Override
    public final S withAdditionalCharacteristics(int additionalCharacteristics) {
        this.characteristics |= additionalCharacteristics;
        return (S)this;
    }

    public final S withShuffler(BigIntegerShuffler shuffler) {
        this.shuffler = shuffler;
        return (S)this;
    }

    public final S withValueSupplier(Splittable.BigIntegerIndexed<T> valueSupplier) {
        this.valueSupplier = valueSupplier;
        return (S)this;
    }

    protected BigInteger getIndex() {
        return this.index;
    }

    protected BigInteger getFence() {
        return this.fence;
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this, false);
    }

    @Override
    public Stream<T> parallelStream() {
        return StreamSupport.stream(this, true);
    }

    @Override
    public long count() {
        BigInteger size = this.bigCount();
        if (size.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
            return size.longValueExact();
        }
        return -1L;
    }

    @Override
    public BigInteger bigCount() {
        return this.fence.subtract(this.index);
    }

    @Override
    public S skip(long n) {
        return (S)this.skip(BigInteger.valueOf(n));
    }

    @Override
    public S skip(BigInteger n) {
        if (n.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("skip(" + n + ")");
        }
        BigInteger targetIndex = this.index.add(n);
        this.index = targetIndex.compareTo(this.fence) >= 0 ? this.fence : targetIndex;
        return (S)this;
    }

    @Override
    public long estimateSize() {
        long size = this.count();
        return size < 0L ? Long.MAX_VALUE : size;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index.compareTo(BigInteger.ZERO) >= 0 && this.index.compareTo(this.fence) < 0) {
            BigInteger shuffledIndex = this.shuffler.getShuffledIndex(this.index);
            Object val = this.valueSupplier.apply(shuffledIndex);
            this.index = this.index.add(BigInteger.ONE);
            action.accept(val);
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        BigInteger mid = this.index.add(this.fence).divide(BigInteger.valueOf(2L));
        if (this.index.compareTo(mid) >= 0) {
            return null;
        }
        S spliterator = ((BigIntegerIndexedSpliterator)((BigIntegerIndexedSpliterator)new BigIntegerIndexedSpliterator<T, S>(this.index, mid).withAdditionalCharacteristics(this.characteristics)).withValueSupplier((Splittable.BigIntegerIndexed)this.valueSupplier.split())).withShuffler(this.shuffler);
        this.index = mid;
        return spliterator;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index.compareTo(BigInteger.ZERO) >= 0 && this.index.compareTo(this.fence) < 0) {
            BigInteger i = this.index;
            while (i.compareTo(this.fence) < 0) {
                BigInteger shuffledIndex = this.shuffler.getShuffledIndex(i);
                Object val = this.valueSupplier.apply(shuffledIndex);
                action.accept(val);
                i = i.add(BigInteger.ONE);
            }
            this.index = this.fence;
        }
    }

    @Override
    public S shuffle(Random rnd) {
        this.shuffler = new DefaultBigIntegerShuffler(this.fence, rnd);
        return (S)this;
    }
}

