/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify;

import java.math.BigInteger;
import java.util.Random;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.beryx.streamplify.Splittable;
import org.beryx.streamplify.Streamable;
import org.beryx.streamplify.permutation.LongPermutations;
import org.beryx.streamplify.shuffler.DefaultLongShuffler;
import org.beryx.streamplify.shuffler.LongShuffler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongIndexedSpliterator<T, S extends LongIndexedSpliterator<T, S>>
implements Spliterator<T>,
Streamable<T, S> {
    private static final Logger logger = LoggerFactory.getLogger(LongPermutations.class);
    private Splittable.LongIndexed<T> valueSupplier;
    private long index;
    private final long fence;
    private int characteristics = 17472;
    private LongShuffler shuffler = LongShuffler.IDENTITY;

    protected LongIndexedSpliterator(long origin, long fence) {
        logger.trace("LongIndexedSpliterator({}, {})", (Object)origin, (Object)fence);
        if (origin < 0L || fence < origin) {
            throw new IllegalArgumentException("origin: " + origin + ", fence: " + fence);
        }
        this.index = origin;
        this.fence = fence;
    }

    @Override
    public final S withAdditionalCharacteristics(int additionalCharacteristics) {
        this.characteristics |= additionalCharacteristics;
        return (S)this;
    }

    public final S withShuffler(LongShuffler shuffler) {
        this.shuffler = shuffler;
        return (S)this;
    }

    public final S withValueSupplier(Splittable.LongIndexed<T> valueSupplier) {
        this.valueSupplier = valueSupplier;
        return (S)this;
    }

    protected final long getIndex() {
        return this.index;
    }

    protected final long getFence() {
        return this.fence;
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this, false);
    }

    @Override
    public Stream<T> parallelStream() {
        return StreamSupport.stream(this, true);
    }

    @Override
    public long count() {
        return this.fence - this.index;
    }

    @Override
    public BigInteger bigCount() {
        return BigInteger.valueOf(this.count());
    }

    @Override
    public S skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("skip(" + n + ")");
        }
        this.index = this.fence - this.index <= n ? this.fence : this.index + n;
        return (S)this;
    }

    @Override
    public S skip(BigInteger bigN) {
        long n;
        if (bigN.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("skip(" + bigN + ")");
        }
        this.index = bigN.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 ? this.fence : (this.fence - this.index <= (n = bigN.longValueExact()) ? this.fence : this.index + n);
        return (S)this;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.index;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index >= 0L && this.index < this.fence) {
            long shuffledIndex = this.shuffler.getShuffledIndex(this.index);
            Object val = this.valueSupplier.apply(shuffledIndex);
            ++this.index;
            action.accept(val);
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        long mid = this.index + this.fence >>> 1;
        if (this.index >= mid) {
            return null;
        }
        S spliterator = ((LongIndexedSpliterator)((LongIndexedSpliterator)new LongIndexedSpliterator<T, S>(this.index, mid).withAdditionalCharacteristics(this.characteristics)).withValueSupplier((Splittable.LongIndexed)this.valueSupplier.split())).withShuffler(this.shuffler);
        this.index = mid;
        return spliterator;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index >= 0L && this.index < this.fence) {
            for (long i = this.index; i < this.fence; ++i) {
                long shuffledIndex = this.shuffler.getShuffledIndex(i);
                Object val = this.valueSupplier.apply(shuffledIndex);
                action.accept(val);
            }
            this.index = this.fence;
        }
    }

    @Override
    public S shuffle(Random rnd) {
        this.shuffler = new DefaultLongShuffler(this.fence, rnd);
        return (S)this;
    }
}

