/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify;

import java.math.BigInteger;
import java.util.function.Function;
import java.util.function.LongFunction;

@FunctionalInterface
public interface Splittable<S extends Splittable<S>> {
    public S split();

    public static interface BigIntegerIndexed<T>
    extends Function<BigInteger, T>,
    Splittable<BigIntegerIndexed<T>> {
        public static final BigIntegerIndexed<BigInteger> IDENTITY = new BigIntegerIndexed<BigInteger>(){

            @Override
            public BigIntegerIndexed<BigInteger> split() {
                return this;
            }

            @Override
            public BigInteger apply(BigInteger value) {
                return value;
            }
        };
    }

    public static interface LongIndexed<T>
    extends LongFunction<T>,
    Splittable<LongIndexed<T>> {
        public static final LongIndexed<Long> IDENTITY = new LongIndexed<Long>(){

            @Override
            public LongIndexed<Long> split() {
                return this;
            }

            @Override
            public Long apply(long value) {
                return value;
            }
        };
    }
}

