/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.combination;

import java.math.BigInteger;
import org.beryx.streamplify.BigIntegerIndexedSpliterator;
import org.beryx.streamplify.combination.CombinationSupplier;

public class BigIntegerCombinations
extends BigIntegerIndexedSpliterator<int[], BigIntegerCombinations> {
    public BigIntegerCombinations(int n, int k) {
        this(BigIntegerCombinations.count(n, k), n, k);
    }

    BigIntegerCombinations(BigInteger count, int n, int k) {
        super(BigInteger.ZERO, count);
        if (n < 0 || k < 0 || n < k) {
            throw new IllegalArgumentException("Invalid (n,k): (" + n + "," + k + ")");
        }
        this.withValueSupplier(new CombinationSupplier.BigInt(count, n, k));
        this.withAdditionalCharacteristics(1);
    }

    protected static BigInteger count(int n, int k) {
        if (n > 50000) {
            throw new IllegalArgumentException("Value too big: " + n);
        }
        BigInteger cnt = BigInteger.ONE;
        for (int i = 0; i < k; ++i) {
            cnt = cnt.multiply(BigInteger.valueOf(n - i));
            cnt = cnt.divide(BigInteger.valueOf(i + 1));
        }
        return cnt;
    }
}

