/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.combination;

import java.math.BigInteger;
import org.beryx.streamplify.IntArraySupplier;
import org.beryx.streamplify.Splittable;
import org.beryx.streamplify.shared.Unranking;

public abstract class CombinationSupplier
implements IntArraySupplier {
    protected final int n;
    protected final int k;
    protected final int[] currentCombination;

    CombinationSupplier(int n, int k) {
        this.n = n;
        this.k = k;
        this.currentCombination = new int[k];
    }

    @Override
    public int[] getCurrentSequence() {
        return this.currentCombination;
    }

    @Override
    public void computeNext() {
        int pos;
        for (pos = this.k - 1; pos >= 0 && this.currentCombination[pos] >= this.n - this.k + pos; --pos) {
        }
        if (pos < 0) {
            return;
        }
        int val = this.currentCombination[pos];
        for (int i = pos; i < this.k; ++i) {
            this.currentCombination[i] = ++val;
        }
    }

    public static class BigInt
    extends CombinationSupplier
    implements Splittable.BigIntegerIndexed<int[]> {
        private final BigInteger count;
        private BigInteger currentIndex = BigInteger.valueOf(-2L);

        public BigInt(BigInteger count, int n, int k) {
            super(n, k);
            this.count = count;
        }

        @Override
        public BigInt split() {
            return new BigInt(this.count, this.n, this.k);
        }

        @Override
        public int[] apply(BigInteger index) {
            boolean useNext = index.equals(this.currentIndex.add(BigInteger.ONE));
            this.currentIndex = index;
            return this.getNextSequence(useNext);
        }

        @Override
        public int[] unrank() {
            return Unranking.unrankCombination(this.n, this.k, this.count, this.currentIndex);
        }
    }

    public static class Long
    extends CombinationSupplier
    implements Splittable.LongIndexed<int[]> {
        private final long count;
        private long currentIndex = -2L;

        public Long(long count, int n, int k) {
            super(n, k);
            this.count = count;
        }

        @Override
        public Long split() {
            return new Long(this.count, this.n, this.k);
        }

        @Override
        public int[] apply(long index) {
            boolean useNext = index == this.currentIndex + 1L;
            this.currentIndex = index;
            return this.getNextSequence(useNext);
        }

        @Override
        public int[] unrank() {
            return Unranking.unrankCombination(this.n, this.k, this.count, this.currentIndex);
        }
    }
}

