/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.combination;

import java.math.BigInteger;
import org.beryx.streamplify.Streamable;
import org.beryx.streamplify.StreamableProxy;
import org.beryx.streamplify.combination.BigIntegerCombinations;
import org.beryx.streamplify.combination.LongCombinations;

public class Combinations
extends StreamableProxy<int[], Combinations> {
    public static final int MAX_N = 50000;
    private final Streamable<int[], ?> delegate;

    public Combinations(int n, int k) {
        BigInteger count = BigIntegerCombinations.count(n, k);
        BigInteger maxVal = count.multiply(BigInteger.valueOf(n - 1));
        this.delegate = maxVal.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) < 0 ? new LongCombinations(count.longValueExact(), n, k) : new BigIntegerCombinations(count, n, k);
    }

    @Override
    protected Streamable<int[], ?> getDelegate() {
        return this.delegate;
    }
}

