/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.combination;

import java.math.BigInteger;
import org.beryx.streamplify.LongIndexedSpliterator;
import org.beryx.streamplify.combination.BigIntegerCombinations;
import org.beryx.streamplify.combination.CombinationSupplier;

public class LongCombinations
extends LongIndexedSpliterator<int[], LongCombinations> {
    public LongCombinations(int n, int k) {
        this(LongCombinations.count(n, k), n, k);
    }

    LongCombinations(long count, int n, int k) {
        super(0L, count);
        if (n < 0 || k < 0 || n < k) {
            throw new IllegalArgumentException("Invalid (n,k): (" + n + "," + k + ")");
        }
        this.withValueSupplier(new CombinationSupplier.Long(count, n, k));
        this.withAdditionalCharacteristics(1);
    }

    protected static long count(int n, int k) {
        BigInteger bigCount = BigIntegerCombinations.count(n, k);
        BigInteger maxVal = bigCount.multiply(BigInteger.valueOf(n - 1));
        if (maxVal.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
            throw new IllegalArgumentException("Combination arguments too big: " + n + ", " + k);
        }
        return bigCount.longValueExact();
    }
}

