/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.derangement;

import java.math.BigInteger;
import org.beryx.streamplify.BigIntegerIndexedSpliterator;
import org.beryx.streamplify.derangement.DerangementSupplier;

public class BigIntegerDerangements
extends BigIntegerIndexedSpliterator<int[], BigIntegerDerangements> {
    public static final int MAX_LENGTH = 20000;

    public BigIntegerDerangements(int length) {
        super(BigInteger.ZERO, BigIntegerDerangements.subfactorial(length));
        this.withValueSupplier(new DerangementSupplier.BigInt(length));
        this.withAdditionalCharacteristics(1);
    }

    public static BigInteger subfactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid derangement length: " + n);
        }
        if (n > 20000) {
            throw new IllegalArgumentException("Value too big: " + n);
        }
        if (n == 0) {
            return BigInteger.ONE;
        }
        BigInteger prev = BigInteger.ONE;
        BigInteger curr = BigInteger.ZERO;
        for (int i = 2; i <= n; ++i) {
            BigInteger next = BigInteger.valueOf(i - 1).multiply(curr.add(prev));
            prev = curr;
            curr = next;
        }
        return curr;
    }
}

