/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.derangement;

import java.math.BigInteger;
import java.util.Arrays;
import org.beryx.streamplify.IntArraySupplier;
import org.beryx.streamplify.Splittable;

public abstract class DerangementSupplier
implements IntArraySupplier {
    protected final int length;
    protected final int[] currentSequence;

    DerangementSupplier(int length) {
        this.length = length;
        this.currentSequence = new int[length];
    }

    public void init() {
        int[] tmp = new Long(this.length).apply(0L);
        System.arraycopy(tmp, 0, this.currentSequence, 0, this.length);
    }

    @Override
    public int[] getCurrentSequence() {
        return this.currentSequence;
    }

    @Override
    public void computeNext() {
        throw new UnsupportedOperationException("computeNext is not supported");
    }

    public static class BigInt
    extends DerangementSupplier
    implements Splittable.BigIntegerIndexed<int[]> {
        private final BigInteger[] subfactorial;
        private BigInteger currentIndex = BigInteger.valueOf(-2L);

        public BigInt(int length) {
            this(length, BigInt.computeSubfactorial(length));
        }

        private BigInt(int length, BigInteger[] subfactorial) {
            super(length);
            this.subfactorial = subfactorial;
        }

        @Override
        public BigInt split() {
            return new BigInt(this.length, this.subfactorial);
        }

        @Override
        public int[] apply(BigInteger index) {
            this.currentIndex = index;
            return this.getNextSequence(false);
        }

        @Override
        public int[] unrank() {
            int[] seq = new int[this.length];
            Arrays.fill(seq, -1);
            int[] avoid = new int[this.length];
            for (int i = 0; i < this.length; ++i) {
                avoid[i] = i;
            }
            int[] reverse = new int[this.length];
            System.arraycopy(avoid, 0, reverse, 0, this.length);
            boolean[] taken = new boolean[this.length];
            BigInteger index = this.currentIndex;
            int remaining = this.length;
            for (int i = 0; i < this.length; ++i) {
                int j;
                if (seq[i] != -1) continue;
                int peer = 0;
                if (remaining > 1) {
                    BigInteger comb = this.subfactorial[remaining - 1].add(this.subfactorial[remaining - 2]);
                    peer = index.divide(comb).intValue();
                    index = index.subtract(BigInteger.valueOf(peer).multiply(comb));
                }
                for (j = 0; taken[j] || j == avoid[i] || peer > 0; ++j) {
                    if (taken[j] || j == avoid[i]) continue;
                    --peer;
                }
                seq[i] = j;
                taken[j] = true;
                if (index.compareTo(this.subfactorial[remaining - 1]) == -1) {
                    avoid[reverse[j]] = avoid[i];
                    reverse[avoid[i]] = reverse[j];
                    --remaining;
                    continue;
                }
                seq[reverse[j]] = avoid[i];
                taken[avoid[i]] = true;
                index = index.subtract(this.subfactorial[remaining - 1]);
                remaining -= 2;
            }
            return seq;
        }

        private static BigInteger[] computeSubfactorial(int len) {
            if (len < 0) {
                return null;
            }
            BigInteger[] subf = new BigInteger[len + 1];
            subf[0] = BigInteger.ONE;
            if (len < 1) {
                return subf;
            }
            subf[1] = BigInteger.ZERO;
            for (int i = 2; i <= len; ++i) {
                subf[i] = BigInteger.valueOf(i - 1).multiply(subf[i - 1].add(subf[i - 2]));
            }
            return subf;
        }
    }

    public static class Long
    extends DerangementSupplier
    implements Splittable.LongIndexed<int[]> {
        private final long[] subfactorial;
        private long currentIndex = -2L;

        public Long(int length) {
            this(length, Long.computeSubfactorial(length));
        }

        private Long(int length, long[] subfactorial) {
            super(length);
            this.subfactorial = subfactorial;
        }

        @Override
        public Long split() {
            return new Long(this.length, this.subfactorial);
        }

        @Override
        public int[] apply(long index) {
            this.currentIndex = index;
            return this.getNextSequence(false);
        }

        @Override
        public int[] unrank() {
            int[] seq = new int[this.length];
            Arrays.fill(seq, -1);
            int[] avoid = new int[this.length];
            for (int i = 0; i < this.length; ++i) {
                avoid[i] = i;
            }
            int[] reverse = new int[this.length];
            System.arraycopy(avoid, 0, reverse, 0, this.length);
            boolean[] taken = new boolean[this.length];
            long index = this.currentIndex;
            int remaining = this.length;
            for (int i = 0; i < this.length; ++i) {
                int j;
                if (seq[i] != -1) continue;
                int peer = 0;
                if (remaining > 1) {
                    long comb = this.subfactorial[remaining - 1] + this.subfactorial[remaining - 2];
                    peer = (int)(index / comb);
                    index -= (long)peer * comb;
                }
                for (j = 0; taken[j] || j == avoid[i] || peer > 0; ++j) {
                    if (taken[j] || j == avoid[i]) continue;
                    --peer;
                }
                seq[i] = j;
                taken[j] = true;
                if (index < this.subfactorial[remaining - 1]) {
                    avoid[reverse[j]] = avoid[i];
                    reverse[avoid[i]] = reverse[j];
                    --remaining;
                    continue;
                }
                seq[reverse[j]] = avoid[i];
                taken[avoid[i]] = true;
                index -= this.subfactorial[remaining - 1];
                remaining -= 2;
            }
            return seq;
        }

        private static long[] computeSubfactorial(int len) {
            if (len < 0) {
                return null;
            }
            long[] subf = new long[len + 1];
            subf[0] = 1L;
            if (len < 1) {
                return subf;
            }
            subf[1] = 0L;
            for (int i = 2; i <= len; ++i) {
                subf[i] = (long)(i - 1) * (subf[i - 1] + subf[i - 2]);
            }
            return subf;
        }
    }
}

