/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.derangement;

import org.beryx.streamplify.LongIndexedSpliterator;
import org.beryx.streamplify.derangement.DerangementSupplier;

public class LongDerangements
extends LongIndexedSpliterator<int[], LongDerangements> {
    public static final int MAX_LENGTH = 21;

    public LongDerangements(int length) {
        super(0L, LongDerangements.subfactorial(length));
        this.withValueSupplier(new DerangementSupplier.Long(length));
        this.withAdditionalCharacteristics(1);
    }

    public static long subfactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid derangement length: " + n);
        }
        if (n > 21) {
            throw new IllegalArgumentException("Derangement length too big: " + n);
        }
        if (n == 0) {
            return 1L;
        }
        long prev = 1L;
        long curr = 0L;
        for (int i = 2; i <= n; ++i) {
            long next = (long)(i - 1) * (curr + prev);
            prev = curr;
            curr = next;
        }
        return curr;
    }
}

