/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.partperm;

import java.math.BigInteger;
import org.beryx.streamplify.BigIntegerIndexedSpliterator;
import org.beryx.streamplify.partperm.PartialPermutationSupplier;

public class BigIntegerPartialPermutations
extends BigIntegerIndexedSpliterator<int[], BigIntegerPartialPermutations> {
    public static final int MAX_LENGTH = 10000;

    public BigIntegerPartialPermutations(int length) {
        super(BigInteger.ZERO, BigIntegerPartialPermutations.numberOfPermutations(length));
        this.withValueSupplier(new PartialPermutationSupplier.BigInt(length));
        this.withAdditionalCharacteristics(1);
    }

    public static BigInteger numberOfPermutations(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid partial permutation length: " + n);
        }
        if (n > 10000) {
            throw new IllegalArgumentException("Partial permutation length too big: " + n);
        }
        BigInteger[] factorials = BigIntegerPartialPermutations.computeFactorials(n);
        BigInteger numberOfPermutations = BigInteger.ZERO;
        for (int i = 0; i <= n; ++i) {
            numberOfPermutations = numberOfPermutations.add(BigIntegerPartialPermutations.computeNextNcK(n, factorials, i));
        }
        return numberOfPermutations;
    }

    public static BigInteger[] computeFactorials(int length) {
        BigInteger[] factorials = new BigInteger[length + 1];
        factorials[0] = BigInteger.ONE;
        for (int i = 1; i <= length; ++i) {
            factorials[i] = factorials[i - 1].multiply(BigInteger.valueOf(i));
        }
        return factorials;
    }

    private static BigInteger computeNextNcK(int n, BigInteger[] factorials, int i) {
        BigInteger nCk = factorials[n].divide(factorials[i].multiply(factorials[n - i]));
        return factorials[i].multiply(nCk.pow(2));
    }
}

