/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.partperm;

import org.beryx.streamplify.LongIndexedSpliterator;
import org.beryx.streamplify.partperm.PartialPermutationSupplier;

public class LongPartialPermutations
extends LongIndexedSpliterator<int[], LongPartialPermutations> {
    public static final int MAX_LENGTH = 18;

    public LongPartialPermutations(int length) {
        super(0L, LongPartialPermutations.numberOfPermutations(length));
        this.withValueSupplier(new PartialPermutationSupplier.Long(length));
        this.withAdditionalCharacteristics(1);
    }

    public static long numberOfPermutations(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid partial permutation length: " + n);
        }
        if (n > 18) {
            throw new IllegalArgumentException("Partial permutation length too big: " + n);
        }
        if (n == 0) {
            return 1L;
        }
        if (n == 1) {
            return 2L;
        }
        return (long)(2 * n) * LongPartialPermutations.numberOfPermutations(n - 1) - (long)Math.pow(n - 1, 2.0) * LongPartialPermutations.numberOfPermutations(n - 2);
    }
}

