/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.partperm;

import java.math.BigInteger;
import java.util.stream.IntStream;
import org.beryx.streamplify.IntArraySupplier;
import org.beryx.streamplify.Splittable;
import org.beryx.streamplify.partperm.BigIntegerPartialPermutations;
import org.beryx.streamplify.shared.Unranking;

public abstract class PartialPermutationSupplier
implements IntArraySupplier {
    public static final int HOLE = -1;
    protected final int length;
    protected final int[] currentPartialPermutation;

    PartialPermutationSupplier(int length) {
        this.length = length;
        this.currentPartialPermutation = new int[length];
    }

    @Override
    public int[] getCurrentSequence() {
        return this.currentPartialPermutation;
    }

    @Override
    public void computeNext() {
        if (!PartialPermutationSupplier.nextPermutation(this.currentPartialPermutation)) {
            int[] currentCombination = this.extractCurrentCombination(this.currentPartialPermutation);
            if (currentCombination != null && PartialPermutationSupplier.nextCombination(currentCombination, this.length)) {
                int[] nextCombination = PartialPermutationSupplier.generateInitialSequence(currentCombination, this.length);
                System.arraycopy(nextCombination, 0, this.currentPartialPermutation, 0, this.length);
            } else {
                if (currentCombination.length == this.length) {
                    return;
                }
                int[] newSubset = IntStream.range(0, currentCombination.length + 1).toArray();
                int[] newStartingCombination = PartialPermutationSupplier.generateInitialSequence(newSubset, this.length);
                System.arraycopy(newStartingCombination, 0, this.currentPartialPermutation, 0, this.length);
            }
        }
    }

    private int[] extractCurrentCombination(int[] permutation) {
        int endOfCombination = this.endOfCombination(permutation);
        int[] combination = new int[endOfCombination];
        for (int i = endOfCombination - 1; i >= 0; --i) {
            combination[endOfCombination - i - 1] = permutation[i];
        }
        return combination;
    }

    private int endOfCombination(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != -1) continue;
            return i;
        }
        return array.length;
    }

    private static int[] generateInitialSequence(int[] currentCombination, int totalLength) {
        int[] initialSequence = new int[totalLength];
        int numberOfHoleElements = totalLength - currentCombination.length;
        for (int i = 0; i < totalLength; ++i) {
            initialSequence[i] = i < numberOfHoleElements ? -1 : currentCombination[i - numberOfHoleElements];
        }
        return initialSequence;
    }

    static boolean nextPermutation(int[] array) {
        int pos;
        for (pos = array.length - 1; pos > 0 && array[pos - 1] >= array[pos]; --pos) {
        }
        if (pos <= 0) {
            return false;
        }
        int swapIdx = array.length - 1;
        int pivotPos = pos - 1;
        while (array[swapIdx] <= array[pivotPos]) {
            --swapIdx;
        }
        PartialPermutationSupplier.swap(array, pivotPos, swapIdx);
        for (swapIdx = array.length - 1; pos < swapIdx; ++pos, --swapIdx) {
            PartialPermutationSupplier.swap(array, pos, swapIdx);
        }
        return true;
    }

    private static void swap(int[] array, int pos, int swapIdx) {
        int temp = array[pos];
        array[pos] = array[swapIdx];
        array[swapIdx] = temp;
    }

    public static boolean nextCombination(int[] currentCombination, int n) {
        int pos;
        int k = currentCombination.length;
        for (pos = k - 1; pos >= 0 && currentCombination[pos] >= n - k + pos; --pos) {
        }
        if (pos < 0) {
            return false;
        }
        int val = currentCombination[pos];
        for (int i = pos; i < k; ++i) {
            currentCombination[i] = ++val;
        }
        return true;
    }

    public static class BigInt
    extends PartialPermutationSupplier
    implements Splittable.BigIntegerIndexed<int[]> {
        private final BigInteger[] divisors;
        private BigInteger currentIndex = BigInteger.valueOf(-2L);

        public BigInt(int length) {
            this(length, BigIntegerPartialPermutations.computeFactorials(length));
        }

        private BigInt(int length, BigInteger[] divisors) {
            super(length);
            this.divisors = divisors;
        }

        @Override
        public BigInt split() {
            return new BigInt(this.length, this.divisors);
        }

        @Override
        public int[] apply(BigInteger index) {
            boolean useNext = index.equals(this.currentIndex.add(BigInteger.ONE));
            this.currentIndex = index;
            return this.getNextSequence(useNext);
        }

        @Override
        public int[] unrank() {
            if (this.length == 0) {
                return new int[0];
            }
            BigInteger prevPermutationCounter = BigInteger.ONE;
            BigInteger permutationCounter = BigInteger.ZERO;
            BigInteger nCk = BigInteger.ONE;
            int subsetSize = 1;
            while (permutationCounter.compareTo(this.currentIndex) == -1) {
                prevPermutationCounter = permutationCounter;
                nCk = BigInt.computeNextNchooseK(nCk, this.length, subsetSize - 1);
                permutationCounter = permutationCounter.add(this.divisors[subsetSize].multiply(nCk.pow(2)));
                ++subsetSize;
            }
            BigInteger partialPermutationIndex = this.currentIndex.subtract(prevPermutationCounter);
            return this.unrankPartialPermutation(partialPermutationIndex, nCk, --subsetSize);
        }

        private int[] unrankPartialPermutation(BigInteger partialPermutationIndex, BigInteger nCk, int subsetSize) {
            int numberOfHoleElements = this.length - subsetSize;
            BigInteger lengthOfPermutations = this.divisors[this.length].divide(this.divisors[numberOfHoleElements]);
            BigInteger[] quotientAndRemainder = partialPermutationIndex.divideAndRemainder(lengthOfPermutations);
            BigInteger combinationIndex = quotientAndRemainder[0];
            BigInteger permutationIndex = quotientAndRemainder[1];
            if (permutationIndex.compareTo(BigInteger.ZERO) == 0) {
                combinationIndex = combinationIndex.subtract(BigInteger.ONE);
                permutationIndex = lengthOfPermutations;
            }
            int[] currentCombination = Unranking.unrankCombination(this.length, subsetSize, nCk, combinationIndex);
            int[] permutationStart = PartialPermutationSupplier.generateInitialSequence(currentCombination, this.length);
            return this.unrankPermutation(permutationStart, permutationIndex.subtract(BigInteger.ONE), numberOfHoleElements, lengthOfPermutations);
        }

        private int[] unrankPermutation(int[] permutation, BigInteger rank, int numberOfHoleElements, BigInteger possiblePermutations) {
            for (int step = 0; step < permutation.length; ++step) {
                int elementFrequency = Math.max(numberOfHoleElements, 1);
                BigInteger numRemainingElements = BigInteger.valueOf(this.length - step);
                BigInteger possibleSuffixes = possiblePermutations.multiply(BigInteger.valueOf(elementFrequency)).divide(numRemainingElements);
                if (rank.compareTo(possibleSuffixes) == -1) {
                    if (permutation[step] == -1) {
                        --numberOfHoleElements;
                    }
                    possiblePermutations = possibleSuffixes;
                    continue;
                }
                if (numberOfHoleElements > 1) {
                    rank = rank.subtract(possibleSuffixes);
                    possibleSuffixes = possiblePermutations.divide(numRemainingElements);
                }
                int targetOffset = rank.divide(possibleSuffixes).intValue();
                rank = rank.subtract(possibleSuffixes.multiply(BigInteger.valueOf(targetOffset)));
                if (numberOfHoleElements > 1) {
                    targetOffset += numberOfHoleElements;
                }
                Long.reorderPermutation(permutation, step, targetOffset);
                possiblePermutations = possibleSuffixes;
            }
            return permutation;
        }

        private static BigInteger computeNextNchooseK(BigInteger prevNcK, int n, int k) {
            BigInteger nCk = prevNcK.multiply(BigInteger.valueOf(n - k));
            return nCk.divide(BigInteger.valueOf(k + 1));
        }
    }

    public static class Long
    extends PartialPermutationSupplier
    implements Splittable.LongIndexed<int[]> {
        private final long[] divisors;
        private long currentIndex = -2L;

        public Long(int length) {
            this(length, Long.computeDivisors(length));
        }

        private Long(int length, long[] divisors) {
            super(length);
            this.divisors = divisors;
        }

        @Override
        public Long split() {
            return new Long(this.length, this.divisors);
        }

        @Override
        public int[] apply(long index) {
            boolean useNext = index == this.currentIndex + 1L;
            this.currentIndex = index;
            return this.getNextSequence(useNext);
        }

        @Override
        public int[] unrank() {
            if (this.length == 0) {
                return new int[0];
            }
            long prevPermutationCounter = 1L;
            BigInteger nCk = BigInteger.ONE;
            int subsetSize = 1;
            long permutationCounter = 0L;
            while (permutationCounter < this.currentIndex) {
                prevPermutationCounter = permutationCounter;
                nCk = BigInt.computeNextNchooseK(nCk, this.length, subsetSize - 1);
                permutationCounter = (long)((double)permutationCounter + (double)this.divisors[subsetSize] * Math.pow(nCk.longValue(), 2.0));
                ++subsetSize;
            }
            long partialPermutationIndex = this.currentIndex - prevPermutationCounter;
            return this.urankPartialPermutation(partialPermutationIndex, nCk, --subsetSize);
        }

        private int[] urankPartialPermutation(long partialPermutationIndex, BigInteger nCk, int subsetSize) {
            int numberOfHoleElements = this.length - subsetSize;
            long lengthOfPermutations = this.divisors[this.length] / this.divisors[numberOfHoleElements];
            long combinationIndex = Math.floorDiv(partialPermutationIndex, lengthOfPermutations);
            long permutationIndex = Math.floorMod(partialPermutationIndex, lengthOfPermutations);
            if (permutationIndex == 0L) {
                --combinationIndex;
                permutationIndex = lengthOfPermutations;
            }
            int[] currentCombination = Unranking.unrankCombination(this.length, subsetSize, nCk.intValue(), combinationIndex);
            int[] permutationStart = PartialPermutationSupplier.generateInitialSequence(currentCombination, this.length);
            return this.unrankPermutation(permutationStart, permutationIndex - 1L, numberOfHoleElements, lengthOfPermutations);
        }

        private int[] unrankPermutation(int[] permutation, long rank, int numberOfHoleElements, long possiblePermutations) {
            for (int step = 0; step < permutation.length; ++step) {
                int elementFrequency = Math.max(numberOfHoleElements, 1);
                long possibleSuffixes = possiblePermutations * (long)elementFrequency / (long)(this.length - step);
                if (rank < possibleSuffixes) {
                    if (permutation[step] == -1) {
                        --numberOfHoleElements;
                    }
                    possiblePermutations = possibleSuffixes;
                    continue;
                }
                if (numberOfHoleElements > 1) {
                    rank -= possibleSuffixes;
                    possibleSuffixes = possiblePermutations / (long)(this.length - step);
                }
                int targetOffset = (int)(rank / possibleSuffixes);
                rank -= possibleSuffixes * (long)targetOffset;
                if (numberOfHoleElements > 1) {
                    targetOffset += numberOfHoleElements;
                }
                Long.reorderPermutation(permutation, step, targetOffset);
                possiblePermutations = possibleSuffixes;
            }
            return permutation;
        }

        private static void reorderPermutation(int[] initialPermutation, int currentIndex, int swapOffset) {
            int valToSwap = initialPermutation[currentIndex + swapOffset];
            System.arraycopy(initialPermutation, currentIndex, initialPermutation, currentIndex + 1, swapOffset);
            initialPermutation[currentIndex] = valToSwap;
        }

        private static long[] computeDivisors(int len) {
            if (len < 1) {
                return null;
            }
            long[] divs = new long[len + 1];
            long fac = 1L;
            divs[0] = 1L;
            for (int i = 1; i <= len; ++i) {
                divs[i] = fac *= (long)i;
            }
            return divs;
        }
    }
}

