/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.permutation;

import java.math.BigInteger;
import org.beryx.streamplify.BigIntegerIndexedSpliterator;
import org.beryx.streamplify.permutation.PermutationSupplier;

public class BigIntegerPermutations
extends BigIntegerIndexedSpliterator<int[], BigIntegerPermutations> {
    public static final int MAX_LENGTH = 20000;

    public BigIntegerPermutations(int length) {
        super(BigInteger.ZERO, BigIntegerPermutations.factorial(length));
        this.withValueSupplier(new PermutationSupplier.BigInt(length));
        this.withAdditionalCharacteristics(1);
    }

    public static BigInteger factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid permutation length: " + n);
        }
        if (n > 20000) {
            throw new IllegalArgumentException("Value too big: " + n);
        }
        BigInteger fact = BigInteger.ONE;
        for (int i = 2; i <= n; ++i) {
            fact = fact.multiply(BigInteger.valueOf(i));
        }
        return fact;
    }
}

