/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.permutation;

import org.beryx.streamplify.LongIndexedSpliterator;
import org.beryx.streamplify.permutation.PermutationSupplier;

public class LongPermutations
extends LongIndexedSpliterator<int[], LongPermutations> {
    public static final int MAX_LENGTH = 20;

    public LongPermutations(int length) {
        super(0L, LongPermutations.factorial(length));
        this.withValueSupplier(new PermutationSupplier.Long(length));
        this.withAdditionalCharacteristics(1);
    }

    public static long factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid permutation length: " + n);
        }
        if (n > 20) {
            throw new IllegalArgumentException("Permutation length too big: " + n);
        }
        long fact = 1L;
        for (int i = 2; i <= n; ++i) {
            fact *= (long)i;
        }
        return fact;
    }
}

