/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.permutation;

import java.math.BigInteger;
import org.beryx.streamplify.IntArraySupplier;
import org.beryx.streamplify.Splittable;

public abstract class PermutationSupplier
implements IntArraySupplier {
    protected final int length;
    protected final int[] currentPermutation;

    PermutationSupplier(int length) {
        this.length = length;
        this.currentPermutation = new int[length];
    }

    @Override
    public int[] getCurrentSequence() {
        return this.currentPermutation;
    }

    @Override
    public void computeNext() {
        int swapIdx;
        int pos;
        for (pos = this.length - 1; pos > 0 && this.currentPermutation[pos] <= this.currentPermutation[pos - 1]; --pos) {
        }
        if (pos == 0) {
            return;
        }
        int pivotPos = pos - 1;
        int pivotVal = this.currentPermutation[pivotPos];
        for (swapIdx = this.length - 1; swapIdx > pivotPos && this.currentPermutation[swapIdx] < pivotVal; --swapIdx) {
        }
        this.currentPermutation[pivotPos] = this.currentPermutation[swapIdx];
        this.currentPermutation[swapIdx] = pivotVal;
        for (int i = 0; i < (this.length - pivotPos - 1) / 2; ++i) {
            int tmp = this.currentPermutation[pivotPos + i + 1];
            this.currentPermutation[pivotPos + i + 1] = this.currentPermutation[this.length - i - 1];
            this.currentPermutation[this.length - i - 1] = tmp;
        }
    }

    public static class BigInt
    extends PermutationSupplier
    implements Splittable.BigIntegerIndexed<int[]> {
        private final BigInteger[] divisors;
        private BigInteger currentIndex = BigInteger.valueOf(-2L);

        public BigInt(int length) {
            this(length, BigInt.computeDivisors(length));
        }

        private BigInt(int length, BigInteger[] divisors) {
            super(length);
            this.divisors = divisors;
        }

        @Override
        public BigInt split() {
            return new BigInt(this.length, this.divisors);
        }

        @Override
        public int[] apply(BigInteger index) {
            boolean useNext = index.equals(this.currentIndex.add(BigInteger.ONE));
            this.currentIndex = index;
            return this.getNextSequence(useNext);
        }

        @Override
        public int[] unrank() {
            int[] perm = new int[this.length];
            for (int i = 0; i < this.length; ++i) {
                perm[i] = i;
            }
            BigInteger dividend = this.currentIndex;
            for (int step = 0; step < this.length - 1; ++step) {
                BigInteger[] quotientAndRemainder = dividend.divideAndRemainder(this.divisors[step]);
                int idx = quotientAndRemainder[0].intValueExact();
                if (idx > 0) {
                    int val = perm[step + idx];
                    System.arraycopy(perm, step, perm, step + 1, idx);
                    perm[step] = val;
                }
                dividend = quotientAndRemainder[1];
            }
            return perm;
        }

        private static BigInteger[] computeDivisors(int len) {
            if (len < 1) {
                return null;
            }
            BigInteger[] divs = new BigInteger[len - 1];
            BigInteger fac = BigInteger.ONE;
            for (int i = 1; i < len; ++i) {
                divs[len - i - 1] = fac = fac.multiply(BigInteger.valueOf(i));
            }
            return divs;
        }
    }

    public static class Long
    extends PermutationSupplier
    implements Splittable.LongIndexed<int[]> {
        private final long[] divisors;
        private long currentIndex = -2L;

        public Long(int length) {
            this(length, Long.computeDivisors(length));
        }

        private Long(int length, long[] divisors) {
            super(length);
            this.divisors = divisors;
        }

        @Override
        public Long split() {
            return new Long(this.length, this.divisors);
        }

        @Override
        public int[] apply(long index) {
            boolean useNext = index == this.currentIndex + 1L;
            this.currentIndex = index;
            return this.getNextSequence(useNext);
        }

        @Override
        public int[] unrank() {
            int[] perm = new int[this.length];
            for (int i = 0; i < this.length; ++i) {
                perm[i] = i;
            }
            long dividend = this.currentIndex;
            for (int step = 0; step < this.length - 1; ++step) {
                int idx = (int)(dividend / this.divisors[step]);
                if (idx > 0) {
                    int val = perm[step + idx];
                    System.arraycopy(perm, step, perm, step + 1, idx);
                    perm[step] = val;
                }
                dividend %= this.divisors[step];
            }
            return perm;
        }

        private static long[] computeDivisors(int len) {
            if (len < 1) {
                return null;
            }
            long[] divs = new long[len - 1];
            long fac = 1L;
            for (int i = 1; i < len; ++i) {
                divs[len - i - 1] = fac *= (long)i;
            }
            return divs;
        }
    }
}

