/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.powerset;

import java.math.BigInteger;
import org.beryx.streamplify.BigIntegerIndexedSpliterator;
import org.beryx.streamplify.powerset.PowerSetSupplier;

public class BigIntegerPowerSet
extends BigIntegerIndexedSpliterator<int[], BigIntegerPowerSet> {
    private static final int MAX_LENGTH = 512;

    public BigIntegerPowerSet(int length) {
        super(BigInteger.ZERO, BigIntegerPowerSet.powerOfTwo(length));
        this.withValueSupplier(new PowerSetSupplier.BigInt(length));
        this.withAdditionalCharacteristics(1);
    }

    private static BigInteger powerOfTwo(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Invalid length of power set");
        }
        if (length >= 512) {
            throw new IllegalArgumentException("Power set size will be too big for length " + length);
        }
        return BigInteger.ONE.shiftLeft(length);
    }
}

