/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.powerset;

import org.beryx.streamplify.LongIndexedSpliterator;
import org.beryx.streamplify.powerset.PowerSetSupplier;

public class LongPowerSet
extends LongIndexedSpliterator<int[], LongPowerSet> {
    public static final int MAX_LENGTH = 63;

    public LongPowerSet(int length) {
        super(0L, LongPowerSet.powerOfTwo(length));
        this.withValueSupplier(new PowerSetSupplier.Long(length));
        this.withAdditionalCharacteristics(1);
    }

    private static long powerOfTwo(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Invalid length of power set");
        }
        if (length >= 63) {
            throw new IllegalArgumentException("Size of power set too long for length " + length);
        }
        return 1L << length;
    }
}

