/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.powerset;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.beryx.streamplify.IntArraySupplier;
import org.beryx.streamplify.Splittable;

public abstract class PowerSetSupplier
implements IntArraySupplier {
    protected final int length;
    protected int[] currentPowerSet;
    protected final int[] binaryCounter;

    public PowerSetSupplier(int length) {
        this.length = length;
        this.currentPowerSet = new int[0];
        this.binaryCounter = new int[length];
    }

    @Override
    public int[] getCurrentSequence() {
        return this.currentPowerSet;
    }

    @Override
    public void computeNext() {
        int index;
        for (index = this.length - 1; index >= 0 && this.binaryCounter[index] == 1; --index) {
        }
        if (index == -1) {
            return;
        }
        this.binaryCounter[index] = 1;
        while (++index < this.length) {
            this.binaryCounter[index] = 0;
        }
        ArrayList<Integer> powerSetList = new ArrayList<Integer>();
        for (int i = this.length - 1; i >= 0; --i) {
            if (this.binaryCounter[i] != 1) continue;
            powerSetList.add(this.length - i - 1);
        }
        this.currentPowerSet = powerSetList.stream().mapToInt(element -> element).toArray();
    }

    @Override
    public int[] getNextSequence(boolean useNext) {
        if (useNext) {
            this.computeNext();
            return this.getCurrentSequence();
        }
        int[] nextSeq = this.unrank();
        this.currentPowerSet = nextSeq;
        this.updateBinaryCounter();
        return nextSeq;
    }

    private void updateBinaryCounter() {
        Arrays.fill(this.binaryCounter, 0);
        for (int element : this.currentPowerSet) {
            this.binaryCounter[element] = 1;
        }
    }

    public static class BigInt
    extends PowerSetSupplier
    implements Splittable.BigIntegerIndexed<int[]> {
        private BigInteger currentIndex = BigInteger.valueOf(-2L);

        public BigInt(int length) {
            super(length);
        }

        @Override
        public int[] apply(BigInteger index) {
            boolean useNext = index.equals(this.currentIndex.add(BigInteger.ONE));
            this.currentIndex = index;
            return this.getNextSequence(useNext);
        }

        @Override
        public Splittable.BigIntegerIndexed<int[]> split() {
            return new BigInt(this.length);
        }

        @Override
        public int[] unrank() {
            ArrayList<Integer> powerSetList = new ArrayList<Integer>();
            BigInteger dividend = this.currentIndex;
            int setElement = 0;
            while (!dividend.equals(BigInteger.ZERO)) {
                BigInteger reminder = dividend.remainder(BigInteger.valueOf(2L));
                if (reminder.equals(BigInteger.ONE)) {
                    powerSetList.add(setElement);
                }
                dividend = dividend.divide(BigInteger.valueOf(2L));
                ++setElement;
            }
            return powerSetList.stream().mapToInt(element -> element).toArray();
        }
    }

    public static class Long
    extends PowerSetSupplier
    implements Splittable.LongIndexed<int[]> {
        private long currentIndex = -2L;

        public Long(int length) {
            super(length);
        }

        @Override
        public int[] apply(long index) {
            boolean useNext = index == this.currentIndex + 1L;
            this.currentIndex = index;
            return this.getNextSequence(useNext);
        }

        @Override
        public Splittable.LongIndexed<int[]> split() {
            return new Long(this.length);
        }

        @Override
        public int[] unrank() {
            ArrayList<Integer> powerSetList = new ArrayList<Integer>();
            long dividend = this.currentIndex;
            int setElement = 0;
            while (dividend != 0L) {
                long reminder = dividend & 1L;
                if (reminder == 1L) {
                    powerSetList.add(setElement);
                }
                dividend >>= 1;
                ++setElement;
            }
            return powerSetList.stream().mapToInt(element -> element).toArray();
        }
    }
}

