/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.product;

import java.math.BigInteger;
import java.util.Arrays;
import org.beryx.streamplify.BigIntegerIndexedSpliterator;
import org.beryx.streamplify.product.CartesianProductSupplier;

public class BigIntegerCartesianProduct
extends BigIntegerIndexedSpliterator<int[], BigIntegerCartesianProduct> {
    public BigIntegerCartesianProduct(int ... dimensions) {
        this(BigIntegerCartesianProduct.count(dimensions), dimensions);
    }

    BigIntegerCartesianProduct(BigInteger count, int ... dimensions) {
        super(BigInteger.ZERO, count);
        if (Arrays.stream(dimensions).anyMatch(dim -> dim < 0)) {
            throw new IllegalArgumentException("Invalid dimensions: " + Arrays.toString(dimensions));
        }
        this.withValueSupplier(new CartesianProductSupplier.BigInt(dimensions, count));
        this.withAdditionalCharacteristics(1);
    }

    protected static BigInteger count(int[] dimensions) {
        BigInteger cnt = BigInteger.ONE;
        int[] nArray = dimensions;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long dim = nArray[i];
            cnt = cnt.multiply(BigInteger.valueOf(dim));
        }
        return cnt;
    }
}

