/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.product;

import java.math.BigInteger;
import org.beryx.streamplify.IntArraySupplier;
import org.beryx.streamplify.Splittable;

public abstract class CartesianProductSupplier
implements IntArraySupplier {
    protected final int[] dimensions;
    protected final int[] currentProduct;

    CartesianProductSupplier(int[] dimensions) {
        this.dimensions = dimensions;
        this.currentProduct = new int[dimensions.length];
    }

    @Override
    public int[] getCurrentSequence() {
        return this.currentProduct;
    }

    @Override
    public void computeNext() {
        int pos;
        for (pos = this.dimensions.length - 1; pos >= 0 && this.currentProduct[pos] >= this.dimensions[pos] - 1; --pos) {
        }
        if (pos < 0) {
            return;
        }
        int n = pos;
        this.currentProduct[n] = this.currentProduct[n] + 1;
        for (int i = pos + 1; i < this.dimensions.length; ++i) {
            this.currentProduct[i] = 0;
        }
    }

    public static class BigInt
    extends CartesianProductSupplier
    implements Splittable.BigIntegerIndexed<int[]> {
        private final BigInteger count;
        private BigInteger currentIndex = BigInteger.valueOf(-2L);

        public BigInt(int[] dimensions, BigInteger count) {
            super(dimensions);
            this.count = count;
        }

        @Override
        public BigInt split() {
            return new BigInt(this.dimensions, this.count);
        }

        @Override
        public int[] apply(BigInteger index) {
            boolean useNext = index.equals(this.currentIndex.add(BigInteger.ONE));
            this.currentIndex = index;
            return this.getNextSequence(useNext);
        }

        @Override
        public int[] unrank() {
            int[] product = new int[this.dimensions.length];
            BigInteger dividend = this.currentIndex;
            for (int k = this.dimensions.length - 1; k >= 0; --k) {
                BigInteger[] quotientAndRemainder = dividend.divideAndRemainder(BigInteger.valueOf(this.dimensions[k]));
                product[k] = quotientAndRemainder[1].intValueExact();
                dividend = quotientAndRemainder[0];
            }
            return product;
        }
    }

    public static class Long
    extends CartesianProductSupplier
    implements Splittable.LongIndexed<int[]> {
        private final long count;
        private long currentIndex = -2L;

        public Long(long count, int[] dimensions) {
            super(dimensions);
            this.count = count;
        }

        @Override
        public Long split() {
            return new Long(this.count, this.dimensions);
        }

        @Override
        public int[] apply(long index) {
            boolean useNext = index == this.currentIndex + 1L;
            this.currentIndex = index;
            return this.getNextSequence(useNext);
        }

        @Override
        public int[] unrank() {
            int[] product = new int[this.dimensions.length];
            long dividend = this.currentIndex;
            for (int k = this.dimensions.length - 1; k >= 0; --k) {
                product[k] = (int)(dividend % (long)this.dimensions[k]);
                dividend /= (long)this.dimensions[k];
            }
            return product;
        }
    }
}

