/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.product;

import java.math.BigInteger;
import java.util.Arrays;
import org.beryx.streamplify.LongIndexedSpliterator;
import org.beryx.streamplify.product.BigIntegerCartesianProduct;
import org.beryx.streamplify.product.CartesianProductSupplier;

public class LongCartesianProduct
extends LongIndexedSpliterator<int[], LongCartesianProduct> {
    public LongCartesianProduct(int ... dimensions) {
        this(LongCartesianProduct.count(dimensions), dimensions);
    }

    public LongCartesianProduct(long count, int ... dimensions) {
        super(0L, count);
        if (Arrays.stream(dimensions).anyMatch(dim -> dim < 0)) {
            throw new IllegalArgumentException("Invalid dimensions: " + Arrays.toString(dimensions));
        }
        this.withValueSupplier(new CartesianProductSupplier.Long(count, dimensions));
        this.withAdditionalCharacteristics(1);
    }

    protected static long count(int[] dimensions) {
        BigInteger bigCount = BigIntegerCartesianProduct.count(dimensions);
        if (bigCount.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
            throw new IllegalArgumentException("Dimensions too big: " + Arrays.toString(dimensions));
        }
        return bigCount.longValueExact();
    }
}

