/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.streamplify.shuffler;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;

public class ShufflerImpl {
    private static final int BYTE_PERMUTATIONS_COUNT = 4;
    private final Random rnd;
    private final int[][] bytePermutations = new int[4][];
    private final int[][] bitPermutations = new int[8][];

    public ShufflerImpl(Random rnd) {
        int i;
        this.rnd = rnd;
        for (i = 0; i < 4; ++i) {
            this.bytePermutations[i] = this.getRandomPermutation(256);
        }
        for (i = 1; i < 8; ++i) {
            this.bitPermutations[i] = this.getRandomPermutation(1 << i);
        }
    }

    public ShufflerImpl withSeed(long seed) {
        this.rnd.setSeed(seed);
        return this;
    }

    public long getShuffledIndex(long index, long count) {
        BigInteger bigIndex = BigInteger.valueOf(index);
        BigInteger bigCount = BigInteger.valueOf(count);
        BigInteger bigShuffled = this.getShuffledIndex(bigIndex, bigCount);
        return bigShuffled.longValueExact();
    }

    public BigInteger getShuffledIndex(BigInteger index, BigInteger count) {
        int i;
        int bitCount = count.subtract(BigInteger.ONE).bitLength();
        int wholeBytes = bitCount / 8;
        int restBits = bitCount % 8;
        int bytesLen = (bitCount + 7) / 8;
        byte[] bytes = index.toByteArray();
        if (bytes.length > bytesLen) {
            if (bytes[0] != 0) {
                throw new AssertionError((Object)("bytes: " + Arrays.toString(bytes)));
            }
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        if (bytes.length < bytesLen) {
            byte[] tmp = bytes;
            bytes = new byte[bytesLen];
            System.arraycopy(tmp, 0, bytes, bytesLen - tmp.length, tmp.length);
        }
        int bytesOff = bytes.length - bytesLen;
        byte[] shuffled = new byte[bytes.length];
        int idx = 0;
        for (i = 0; i < wholeBytes; ++i) {
            idx = (bytes[bytesLen + bytesOff - 1 - i] ^ idx) & 0xFF;
            shuffled[i + bytesOff] = (byte)this.bytePermutations[i % 4][idx];
        }
        if (restBits > 0) {
            idx = (bytes[bytesOff] ^ idx) & (1 << restBits) - 1;
            int shuffledByte = this.bitPermutations[restBits][idx];
            shuffled[bytesLen + bytesOff - 1] = (byte)(shuffledByte << 8 - restBits);
        }
        for (i = 0; i < bytes.length - 1; ++i) {
            int n = bytes.length - 2 - i;
            shuffled[n] = (byte)(shuffled[n] ^ shuffled[bytes.length - 1 - i]);
        }
        BigInteger bigShuffled = new BigInteger(1, shuffled);
        if (restBits > 0) {
            bigShuffled = bigShuffled.shiftRight(8 - restBits);
        }
        if (bigShuffled.compareTo(count) < 0) {
            return bigShuffled;
        }
        return this.getShuffledIndex(bigShuffled, count);
    }

    public int[] getRandomPermutation(int length) {
        int[] perm = new int[length];
        int i = 0;
        while (i < length) {
            int j = this.rnd.nextInt(i + 1);
            if (j != i) {
                perm[i] = perm[j];
            }
            perm[j] = i++;
        }
        return perm;
    }
}

