/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.List;
import java.util.function.Supplier;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextTerminal;

public abstract class ComparableInputReader<T extends Comparable<T>, B extends ComparableInputReader<T, B>>
extends InputReader<T, B> {
    protected T minVal;
    protected T maxVal;

    protected abstract String typeNameWithIndefiniteArticle();

    public ComparableInputReader(Supplier<TextTerminal> textTerminalSupplier) {
        super(textTerminalSupplier);
    }

    public B withMinVal(T minVal) {
        this.minVal = minVal;
        return (B)this;
    }

    public B withMaxVal(T maxVal) {
        this.maxVal = maxVal;
        return (B)this;
    }

    @Override
    protected List<String> getDefaultErrorMessage(String s) {
        List<String> errList = super.getDefaultErrorMessage(s);
        if (this.minVal != null && this.maxVal != null) {
            errList.add("Expected " + this.typeNameWithIndefiniteArticle() + " value between " + this.minVal + " and " + this.maxVal + ".");
        } else if (this.minVal != null) {
            errList.add("Expected " + this.typeNameWithIndefiniteArticle() + " value greater than or equal to " + this.minVal + ".");
        } else if (this.maxVal != null) {
            errList.add("Expected " + this.typeNameWithIndefiniteArticle() + " value less than or equal to " + this.maxVal + ".");
        } else {
            errList.add("Expected " + this.typeNameWithIndefiniteArticle() + " value.");
        }
        return errList;
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException {
        super.checkConfiguration();
        if (this.minVal != null && this.maxVal != null && this.minVal.compareTo(this.maxVal) > 0) {
            throw new IllegalArgumentException("minVal = " + this.minVal + ", maxVal = " + this.maxVal);
        }
        if (this.defaultValue != null) {
            if (this.minVal != null && ((Comparable)this.defaultValue).compareTo(this.minVal) < 0) {
                throw new IllegalArgumentException("minVal = " + this.minVal + ", defaultValue = " + this.defaultValue);
            }
            if (this.maxVal != null && ((Comparable)this.defaultValue).compareTo(this.maxVal) > 0) {
                throw new IllegalArgumentException("maxVal = " + this.maxVal + ", defaultValue = " + this.defaultValue);
            }
        }
    }

    public boolean isInRange(T val) {
        return !(this.minVal != null && this.minVal.compareTo(val) > 0 || this.maxVal != null && this.maxVal.compareTo(val) < 0);
    }
}

