/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.function.Supplier;
import org.beryx.textio.ComparableInputReader;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextTerminal;

public class DoubleInputReader
extends ComparableInputReader<Double, DoubleInputReader> {
    public DoubleInputReader(Supplier<TextTerminal> textTerminalSupplier) {
        super(textTerminalSupplier);
    }

    @Override
    protected String typeNameWithIndefiniteArticle() {
        return "a double";
    }

    @Override
    public InputReader.ParseResult<Double> parse(String s) {
        try {
            Double val = Double.parseDouble(s);
            return this.isInRange(val) ? new InputReader.ParseResult<Double>(val) : new InputReader.ParseResult<Double>(val, this.getErrorMessage(s));
        }
        catch (NumberFormatException e) {
            return new InputReader.ParseResult<Object>(null, this.getErrorMessage(s));
        }
    }
}

