/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.beryx.textio.TextTerminal;

public abstract class InputReader<T, B extends InputReader<T, B>> {
    protected final Supplier<TextTerminal> textTerminalSupplier;
    protected T defaultValue;
    protected List<T> possibleValues;
    protected boolean numberedPossibleValues = false;
    protected ErrorMessageProvider errorMessageProvider;
    protected String propertyName;
    protected boolean inputMasking = false;
    protected boolean inputTrimming = true;
    protected Function<T, String> valueFormatter = val -> String.valueOf(val);

    public abstract ParseResult<T> parse(String var1);

    public InputReader(Supplier<TextTerminal> textTerminalSupplier) {
        this.textTerminalSupplier = textTerminalSupplier;
    }

    public B withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return (B)this;
    }

    public B withPossibleValues(T ... possibleValues) {
        this.possibleValues = null;
        if (possibleValues.length > 0) {
            this.possibleValues = new ArrayList<T>();
            for (T val : possibleValues) {
                this.possibleValues.add(val);
            }
        }
        return (B)this;
    }

    public B withPossibleValues(List<T> possibleValues) {
        this.possibleValues = possibleValues != null && possibleValues.isEmpty() ? null : possibleValues;
        return (B)this;
    }

    public B withNumberedPossibleValues(boolean numbered) {
        this.numberedPossibleValues = numbered;
        return (B)this;
    }

    public B withInputMasking(boolean inputMasking) {
        this.inputMasking = inputMasking;
        return (B)this;
    }

    public B withInputTrimming(boolean inputTrimming) {
        this.inputTrimming = inputTrimming;
        return (B)this;
    }

    public B withPropertyName(String propertyName) {
        this.propertyName = "".equals(propertyName) ? null : propertyName;
        return (B)this;
    }

    public B withValueFormatter(Function<T, String> valueFormatter) {
        this.valueFormatter = valueFormatter;
        return (B)this;
    }

    public B withErrorMessageProvider(ErrorMessageProvider errorMessageProvider) {
        this.errorMessageProvider = errorMessageProvider;
        return (B)this;
    }

    protected String getDefaultErrorMessage() {
        StringBuilder errBuilder = new StringBuilder("Invalid value");
        if (this.propertyName != null) {
            errBuilder.append(" for '" + this.propertyName + "'");
        }
        errBuilder.append('.');
        return errBuilder.toString();
    }

    protected List<String> getDefaultErrorMessage(String s) {
        return new ArrayList<String>(Collections.singleton(this.getDefaultErrorMessage()));
    }

    public final List<String> getErrorMessage(String s) {
        ErrorMessageProvider provider = this.errorMessageProvider != null ? this.errorMessageProvider : (sVal, pVal) -> this.getDefaultErrorMessage(sVal);
        return provider.getErrorMessage(s, this.propertyName);
    }

    public T read(String ... prompt) {
        return this.read(Arrays.asList(prompt));
    }

    public T read(List<String> prompt) {
        this.checkConfiguration();
        TextTerminal textTerminal = this.textTerminalSupplier.get();
        while (true) {
            this.printPrompt(prompt, textTerminal, this.possibleValues);
            String sVal = textTerminal.read(this.inputMasking);
            if (sVal != null && this.inputTrimming) {
                sVal = sVal.trim();
            }
            if ((sVal == null || sVal.isEmpty()) && this.defaultValue != null) {
                return this.defaultValue;
            }
            if (this.possibleValues == null || !this.numberedPossibleValues) {
                ParseResult<T> result = this.parse(sVal);
                List<String> errMessages = result.getErrorMessages();
                if (errMessages == null) {
                    if (this.possibleValues == null || this.possibleValues.contains(result.getValue())) {
                        return result.getValue();
                    }
                    textTerminal.print(this.getDefaultErrorMessage());
                    textTerminal.println(" You must enter one of the displayed values.");
                    textTerminal.println();
                    continue;
                }
                textTerminal.println(errMessages);
                textTerminal.println();
                continue;
            }
            try {
                int optIndex = Integer.parseInt(sVal);
                if (optIndex > 0 && optIndex <= this.possibleValues.size()) {
                    return this.possibleValues.get(optIndex - 1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            textTerminal.print(this.getDefaultErrorMessage());
            textTerminal.println(" Enter a value between 1 and " + this.possibleValues.size() + ".");
            textTerminal.println();
        }
    }

    public void checkConfiguration() throws IllegalArgumentException {
        if (this.possibleValues != null && this.defaultValue != null && !this.possibleValues.contains(this.defaultValue)) {
            throw new IllegalArgumentException("Invalid default value: " + this.defaultValue + ". Allowed values: " + this.possibleValues);
        }
    }

    protected void printPrompt(List<String> prompt, TextTerminal textTerminal, List<T> options) {
        textTerminal.print(prompt);
        boolean useColon = false;
        if (prompt != null && !prompt.isEmpty()) {
            String lastLine = prompt.get(prompt.size() - 1);
            boolean bl = useColon = !lastLine.isEmpty() && Character.isJavaIdentifierPart(lastLine.charAt(lastLine.length() - 1));
        }
        if (options == null) {
            if (this.defaultValue != null) {
                textTerminal.print(" [" + this.defaultValue + "]");
            }
            textTerminal.print(useColon ? ": " : " ");
        } else {
            textTerminal.println(useColon ? ":" : "");
            for (int i = 0; i < options.size(); ++i) {
                T option = options.get(i);
                boolean isDefault = this.defaultValue != null && this.defaultValue.equals(option);
                textTerminal.println((isDefault ? "* " : "  ") + (this.numberedPossibleValues ? i + 1 + ": " : "") + this.valueFormatter.apply(option));
            }
            textTerminal.print("Enter your choice: ");
        }
    }

    public static class ParseResult<T> {
        private final T value;
        private final List<String> errorMessages;

        public ParseResult(T value) {
            this.value = value;
            this.errorMessages = null;
        }

        public ParseResult(T value, List<String> errorMessages) {
            this.value = value;
            this.errorMessages = errorMessages != null && errorMessages.isEmpty() ? null : errorMessages;
        }

        public ParseResult(T value, String ... errorMessages) {
            this.value = value;
            this.errorMessages = errorMessages.length == 0 ? null : Arrays.asList(errorMessages);
        }

        public T getValue() {
            return this.value;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }
    }

    @FunctionalInterface
    public static interface ErrorMessageProvider {
        public List<String> getErrorMessage(String var1, String var2);
    }
}

