/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextTerminal;

public class StringInputReader
extends InputReader<String, StringInputReader> {
    private Pattern pattern;
    private int minLength = 1;
    private int maxLength = -1;

    public StringInputReader(Supplier<TextTerminal> textTerminalSupplier) {
        super(textTerminalSupplier);
        this.numberedPossibleValues = true;
    }

    public StringInputReader withPattern(String regex) {
        this.pattern = regex == null ? null : Pattern.compile(regex);
        return this;
    }

    public StringInputReader withPattern(String regex, int flags) {
        this.pattern = regex == null ? null : Pattern.compile(regex, flags);
        return this;
    }

    public StringInputReader withMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public StringInputReader withMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Override
    protected List<String> getDefaultErrorMessage(String s) {
        List<String> errList = super.getDefaultErrorMessage(s);
        String validationErr = this.getValidationError(s);
        if (validationErr != null) {
            errList.add(validationErr);
        }
        return errList;
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException {
        super.checkConfiguration();
        if (this.minLength > 0 && this.maxLength > 0 && this.minLength > this.maxLength) {
            throw new IllegalArgumentException("minLength = " + this.minLength + ", maxLength = " + this.maxLength);
        }
        if (this.defaultValue != null) {
            if (this.minLength > 0 && this.minLength > ((String)this.defaultValue).length()) {
                throw new IllegalArgumentException("minLength = " + this.minLength + ", defaultValue = " + (String)this.defaultValue);
            }
            if (this.maxLength > 0 && this.maxLength < ((String)this.defaultValue).length()) {
                throw new IllegalArgumentException("maxLength = " + this.maxLength + ", defaultValue = " + (String)this.defaultValue);
            }
        }
    }

    @Override
    public InputReader.ParseResult<String> parse(String s) {
        if (this.getValidationError(s) == null) {
            return new InputReader.ParseResult<String>(s);
        }
        return new InputReader.ParseResult<String>(s, this.getErrorMessage(s));
    }

    private String getValidationError(String s) {
        if (this.possibleValues == null) {
            int len = s == null ? 0 : s.length();
            IntFunction<String> chr = l -> l + " character" + (l > 1 ? "s." : ".");
            if (this.minLength > 0 && this.minLength > len) {
                return "Expected a string with at least " + chr.apply(this.minLength);
            }
            if (this.maxLength > 0 && this.maxLength < len) {
                return "Expected a string with at most " + chr.apply(this.maxLength);
            }
            if (this.pattern != null && !this.pattern.matcher(s).matches()) {
                return "Expected format: " + this.pattern.pattern();
            }
        }
        return null;
    }
}

