/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.function.Function;
import java.util.function.Supplier;
import org.beryx.textio.BooleanInputReader;
import org.beryx.textio.DoubleInputReader;
import org.beryx.textio.EnumInputReader;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.InputReader;
import org.beryx.textio.IntInputReader;
import org.beryx.textio.LongInputReader;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextTerminal;

public class TextIO {
    private final TextTerminal textTerminal;
    private final Supplier<TextTerminal> textTerminalSupplier;

    public TextIO(TextTerminal textTerminal) {
        this.textTerminal = textTerminal;
        this.textTerminalSupplier = () -> textTerminal;
    }

    public TextTerminal getTextTerminal() {
        return this.textTerminal;
    }

    public void dispose() {
        this.textTerminal.dispose();
    }

    public BooleanInputReader newBooleanInputReader() {
        return new BooleanInputReader(this.textTerminalSupplier);
    }

    public DoubleInputReader newDoubleInputReader() {
        return new DoubleInputReader(this.textTerminalSupplier);
    }

    public IntInputReader newIntInputReader() {
        return new IntInputReader(this.textTerminalSupplier);
    }

    public LongInputReader newLongInputReader() {
        return new LongInputReader(this.textTerminalSupplier);
    }

    public StringInputReader newStringInputReader() {
        return new StringInputReader(this.textTerminalSupplier);
    }

    public <T extends Enum<T>> EnumInputReader<T> newEnumInputReader(Class<T> enumClass) {
        return new EnumInputReader<T>(this.textTerminalSupplier, enumClass);
    }

    public <T> GenericInputReader<T> newGenericInputReader(Function<String, InputReader.ParseResult<T>> parser) {
        return new GenericInputReader<T>(this.textTerminalSupplier, parser);
    }
}

