/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.List;
import java.util.function.Supplier;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextTerminal;

public class BooleanInputReader
extends InputReader<Boolean, BooleanInputReader> {
    private String trueInput = "true";
    private String falseInput = "false";

    public BooleanInputReader(Supplier<TextTerminal> textTerminalSupplier) {
        super(textTerminalSupplier);
    }

    public BooleanInputReader withTrueInput(String trueInput) {
        if (trueInput == null || trueInput.trim().isEmpty()) {
            throw new IllegalArgumentException("trueInput is empty");
        }
        this.trueInput = trueInput;
        return this;
    }

    public BooleanInputReader withFalseInput(String falseInput) {
        if (falseInput == null || falseInput.trim().isEmpty()) {
            throw new IllegalArgumentException("falseInput is empty");
        }
        this.falseInput = falseInput;
        return this;
    }

    @Override
    protected List<String> getDefaultErrorMessages(String s) {
        List<String> errList = super.getDefaultErrorMessages(s);
        errList.add("Expected: " + this.trueInput + " / " + this.falseInput);
        return errList;
    }

    @Override
    protected InputReader.ParseResult<Boolean> parse(String s) {
        if (this.trueInput.equalsIgnoreCase(s)) {
            return new InputReader.ParseResult<Boolean>(true);
        }
        if (this.falseInput.equalsIgnoreCase(s)) {
            return new InputReader.ParseResult<Boolean>(false);
        }
        return new InputReader.ParseResult<Object>(null, this.getErrorMessages(s));
    }
}

