/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.beryx.textio.TextTerminal;

public abstract class InputReader<T, B extends InputReader<T, B>> {
    protected final Supplier<TextTerminal> textTerminalSupplier;
    protected T defaultValue;
    protected List<T> possibleValues;
    protected boolean numberedPossibleValues = false;
    protected ErrorMessagesProvider parseErrorMessagesProvider;
    protected String propertyName;
    protected boolean inputMasking = false;
    protected boolean inputTrimming = true;
    protected final List<ValueChecker<T>> valueCheckers = new ArrayList<ValueChecker<T>>();
    protected Function<T, String> valueFormatter = String::valueOf;
    protected BiFunction<T, T, Boolean> equalsFunc = Objects::equals;

    protected abstract ParseResult<T> parse(String var1);

    public InputReader(Supplier<TextTerminal> textTerminalSupplier) {
        this.textTerminalSupplier = textTerminalSupplier;
    }

    public B withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return (B)this;
    }

    public B withPossibleValues(T ... possibleValues) {
        this.possibleValues = null;
        if (possibleValues.length > 0) {
            this.possibleValues = new ArrayList<T>();
            for (T val : possibleValues) {
                this.possibleValues.add(val);
            }
        }
        return (B)this;
    }

    public B withPossibleValues(List<T> possibleValues) {
        this.possibleValues = possibleValues != null && possibleValues.isEmpty() ? null : possibleValues;
        return (B)this;
    }

    public B withNumberedPossibleValues(boolean numbered) {
        this.numberedPossibleValues = numbered;
        return (B)this;
    }

    public B withInputMasking(boolean inputMasking) {
        this.inputMasking = inputMasking;
        return (B)this;
    }

    public B withInputTrimming(boolean inputTrimming) {
        this.inputTrimming = inputTrimming;
        return (B)this;
    }

    public B withPropertyName(String propertyName) {
        this.propertyName = "".equals(propertyName) ? null : propertyName;
        return (B)this;
    }

    public B withValueFormatter(Function<T, String> valueFormatter) {
        this.valueFormatter = valueFormatter;
        return (B)this;
    }

    public B withEqualsFunc(BiFunction<T, T, Boolean> equalsFunc) {
        this.equalsFunc = equalsFunc;
        return (B)this;
    }

    public B withParseErrorMessagesProvider(ErrorMessagesProvider parseErrorMessagesProvider) {
        this.parseErrorMessagesProvider = parseErrorMessagesProvider;
        return (B)this;
    }

    public B withValueChecker(ValueChecker<T> valueChecker) {
        this.valueCheckers.add(valueChecker);
        return (B)this;
    }

    protected String getDefaultErrorMessage() {
        StringBuilder errBuilder = new StringBuilder("Invalid value");
        if (this.propertyName != null) {
            errBuilder.append(" for '" + this.propertyName + "'");
        }
        errBuilder.append('.');
        return errBuilder.toString();
    }

    protected List<String> getDefaultErrorMessages(String s) {
        return new ArrayList<String>(Collections.singleton(this.getDefaultErrorMessage()));
    }

    protected final List<String> getErrorMessages(String s) {
        if (this.parseErrorMessagesProvider != null) {
            return this.parseErrorMessagesProvider.getErrorMessages(s, this.propertyName);
        }
        return this.getDefaultErrorMessages(s);
    }

    protected ParseResult<T> parseAndCheck(String s) {
        ParseResult<Object> res = this.parse(s);
        if (((ParseResult)res).errorMessages == null) {
            ArrayList<String> allErrors = new ArrayList<String>();
            for (ValueChecker<Object> valueChecker : this.valueCheckers) {
                List<String> errors = valueChecker.getErrorMessages(((ParseResult)res).value, this.propertyName);
                if (errors == null) continue;
                allErrors.addAll(errors);
            }
            if (!allErrors.isEmpty()) {
                allErrors.add(0, this.getDefaultErrorMessage());
                res = new ParseResult<Object>(((ParseResult)res).value, allErrors);
            }
        }
        return res;
    }

    public T read(String ... prompt) {
        return this.read(Arrays.asList(prompt));
    }

    public T read(List<String> prompt) {
        this.checkConfiguration();
        TextTerminal textTerminal = this.textTerminalSupplier.get();
        while (true) {
            this.printPrompt(prompt, textTerminal, this.possibleValues);
            String sVal = textTerminal.read(this.inputMasking);
            if (sVal != null && this.inputTrimming) {
                sVal = sVal.trim();
            }
            if ((sVal == null || sVal.isEmpty()) && this.defaultValue != null) {
                return this.defaultValue;
            }
            if (this.possibleValues == null || !this.numberedPossibleValues) {
                ParseResult<T> result = this.parseAndCheck(sVal);
                List<String> errMessages = result.getErrorMessages();
                if (errMessages == null) {
                    if (this.isPossibleValue(result.getValue())) {
                        return result.getValue();
                    }
                    textTerminal.print(this.getDefaultErrorMessage());
                    textTerminal.println(" You must enter one of the displayed values.");
                    textTerminal.println();
                    continue;
                }
                textTerminal.println(errMessages);
                textTerminal.println();
                continue;
            }
            try {
                int optIndex = Integer.parseInt(sVal);
                if (optIndex > 0 && optIndex <= this.possibleValues.size()) {
                    return this.possibleValues.get(optIndex - 1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            textTerminal.print(this.getDefaultErrorMessage());
            textTerminal.println(" Enter a value between 1 and " + this.possibleValues.size() + ".");
            textTerminal.println();
        }
    }

    protected boolean isPossibleValue(T val) {
        if (this.possibleValues == null) {
            return true;
        }
        for (T pVal : this.possibleValues) {
            if (!this.equalsFunc.apply(pVal, val).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected void checkConfiguration() throws IllegalArgumentException {
        if (this.defaultValue != null && !this.isPossibleValue(this.defaultValue)) {
            throw new IllegalArgumentException("Invalid default value: " + this.valueFormatter.apply(this.defaultValue) + ". Allowed values: " + this.possibleValues);
        }
        for (ValueChecker<T> checker : this.valueCheckers) {
            List<String> errors = null;
            if (this.defaultValue != null && (errors = checker.getErrorMessages(this.defaultValue, this.propertyName)) != null) {
                throw new IllegalArgumentException("Invalid default value: " + this.valueFormatter.apply(this.defaultValue) + ".\n" + errors);
            }
            if (this.possibleValues == null) continue;
            for (T val : this.possibleValues) {
                errors = checker.getErrorMessages(val, this.propertyName);
                if (errors == null) continue;
                throw new IllegalArgumentException("Invalid entry in the list of possible values: " + this.valueFormatter.apply(val) + ".\n" + errors);
            }
        }
    }

    protected void printPrompt(List<String> prompt, TextTerminal textTerminal, List<T> options) {
        textTerminal.print(prompt);
        boolean useColon = false;
        if (prompt != null && !prompt.isEmpty()) {
            String lastLine = prompt.get(prompt.size() - 1);
            boolean bl = useColon = !lastLine.isEmpty() && Character.isJavaIdentifierPart(lastLine.charAt(lastLine.length() - 1));
        }
        if (options == null) {
            if (this.defaultValue != null) {
                textTerminal.print(" [" + this.defaultValue + "]");
            }
            textTerminal.print(useColon ? ": " : " ");
        } else {
            textTerminal.println(useColon ? ":" : "");
            for (int i = 0; i < options.size(); ++i) {
                T option = options.get(i);
                boolean isDefault = this.defaultValue != null && this.equalsFunc.apply(this.defaultValue, option) != false;
                textTerminal.println((isDefault ? "* " : "  ") + (this.numberedPossibleValues ? i + 1 + ": " : "") + this.valueFormatter.apply(option));
            }
            textTerminal.print("Enter your choice: ");
        }
    }

    public static class ParseResult<T> {
        private final T value;
        private final List<String> errorMessages;

        public ParseResult(T value) {
            this.value = value;
            this.errorMessages = null;
        }

        public ParseResult(T value, List<String> errorMessages) {
            this.value = value;
            this.errorMessages = errorMessages != null && errorMessages.isEmpty() ? null : errorMessages;
        }

        public ParseResult(T value, String ... errorMessages) {
            this.value = value;
            this.errorMessages = errorMessages.length == 0 ? null : Arrays.asList(errorMessages);
        }

        public T getValue() {
            return this.value;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }
    }

    @FunctionalInterface
    public static interface ValueChecker<T> {
        public List<String> getErrorMessages(T var1, String var2);
    }

    @FunctionalInterface
    public static interface ErrorMessagesProvider {
        public List<String> getErrorMessages(String var1, String var2);
    }
}

