/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextTerminal;
import org.beryx.textio.TextTerminalProvider;
import org.beryx.textio.console.ConsoleTextTerminalProvider;
import org.beryx.textio.swing.SwingTextTerminalProvider;
import org.beryx.textio.system.SystemTextTerminalProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIoFactory {
    private static final Logger logger = LoggerFactory.getLogger(TextIoFactory.class);
    public static final String TEXT_TERMINAL_CLASS_PROPERTY = "org.beryx.textio.TextTerminal";

    public static TextTerminal getTextTerminal() {
        return Holder.INSTANCE.terminal;
    }

    public static TextIO getTextIO() {
        return Holder.INSTANCE.textIO;
    }

    private static class Holder {
        static Holder INSTANCE = new Holder();
        final TextTerminal terminal;
        final TextIO textIO;

        private Holder() {
            TextTerminal t = this.getTerminalFromProperty();
            if (t == null) {
                t = this.getTerminalFromService();
            }
            if (t == null) {
                t = this.getDefaultTerminal();
            }
            this.terminal = t;
            this.textIO = new TextIO(t);
        }

        private TextTerminal getTerminalFromProperty() {
            String clsName = System.getProperty(TextIoFactory.TEXT_TERMINAL_CLASS_PROPERTY, "").trim();
            if (clsName.isEmpty()) {
                return null;
            }
            try {
                Class<?> cls = Class.forName(clsName);
                return (TextTerminal)cls.newInstance();
            }
            catch (Exception e) {
                logger.warn("Unable to create a TextTerminal of type " + clsName);
                return null;
            }
        }

        private TextTerminal getTerminalFromService() {
            ServiceLoader<TextTerminalProvider> svcLoader = ServiceLoader.load(TextTerminalProvider.class);
            Iterator<TextTerminalProvider> it = svcLoader.iterator();
            while (it.hasNext()) {
                TextTerminal t = it.next().getTextTerminal();
                if (t == null) continue;
                return t;
            }
            return null;
        }

        private TextTerminal getDefaultTerminal() {
            TextTerminal terminal = new ConsoleTextTerminalProvider().getTextTerminal();
            if (terminal != null) {
                return terminal;
            }
            terminal = new SwingTextTerminalProvider().getTextTerminal();
            if (terminal != null) {
                return terminal;
            }
            terminal = new SystemTextTerminalProvider().getTextTerminal();
            return terminal;
        }
    }
}

