/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.beryx.textio.TextTerminal;

public abstract class InputReader<T, B extends InputReader<T, B>> {
    protected final Supplier<TextTerminal> textTerminalSupplier;
    protected T defaultValue;
    protected List<T> possibleValues;
    protected boolean numberedPossibleValues = false;
    protected ErrorMessagesProvider parseErrorMessagesProvider;
    protected String propertyName;
    protected boolean inputMasking = false;
    protected boolean inputTrimming = true;
    protected boolean promptAdjustments = true;
    protected final List<ValueChecker<T>> valueCheckers = new ArrayList<ValueChecker<T>>();
    protected final List<ValueChecker<List<T>>> valueListCheckers = new ArrayList<ValueChecker<List<T>>>();
    protected Function<T, String> valueFormatter = String::valueOf;
    protected BiFunction<T, T, Boolean> equalsFunc = Objects::equals;
    private boolean valueListMode = false;

    protected abstract ParseResult<T> parse(String var1);

    public InputReader(Supplier<TextTerminal> textTerminalSupplier) {
        this.textTerminalSupplier = textTerminalSupplier;
    }

    public B withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return (B)this;
    }

    public B withPossibleValues(T ... possibleValues) {
        this.possibleValues = null;
        if (possibleValues.length > 0) {
            this.possibleValues = new ArrayList<T>();
            for (T val : possibleValues) {
                this.possibleValues.add(val);
            }
        }
        return (B)this;
    }

    public B withPossibleValues(List<T> possibleValues) {
        this.possibleValues = possibleValues != null && possibleValues.isEmpty() ? null : possibleValues;
        return (B)this;
    }

    public B withNumberedPossibleValues(boolean numbered) {
        this.numberedPossibleValues = numbered;
        return (B)this;
    }

    public B withInputMasking(boolean inputMasking) {
        this.inputMasking = inputMasking;
        return (B)this;
    }

    public B withInputTrimming(boolean inputTrimming) {
        this.inputTrimming = inputTrimming;
        return (B)this;
    }

    public B withPromptAdjustments(boolean promptAdjustment) {
        this.promptAdjustments = promptAdjustment;
        return (B)this;
    }

    public B withPropertyName(String propertyName) {
        this.propertyName = "".equals(propertyName) ? null : propertyName;
        return (B)this;
    }

    public B withValueFormatter(Function<T, String> valueFormatter) {
        this.valueFormatter = valueFormatter;
        return (B)this;
    }

    public B withEqualsFunc(BiFunction<T, T, Boolean> equalsFunc) {
        this.equalsFunc = equalsFunc;
        return (B)this;
    }

    public B withParseErrorMessagesProvider(ErrorMessagesProvider parseErrorMessagesProvider) {
        this.parseErrorMessagesProvider = parseErrorMessagesProvider;
        return (B)this;
    }

    public B withValueChecker(ValueChecker<T> valueChecker) {
        this.valueCheckers.add(valueChecker);
        return (B)this;
    }

    public B withValueListChecker(ValueChecker<List<T>> valueListChecker) {
        this.valueListCheckers.add(valueListChecker);
        return (B)this;
    }

    public boolean isValueListMode() {
        return this.valueListMode;
    }

    protected String getDefaultErrorMessage(String sVal) {
        StringBuilder errBuilder = new StringBuilder("Invalid value");
        if (this.valueListMode) {
            errBuilder.append(" in the comma-separated list");
            if (this.propertyName != null) {
                errBuilder.append(" of '" + this.propertyName + "'");
            }
            if (sVal != null && !sVal.isEmpty()) {
                errBuilder.append(": " + sVal);
            }
        } else if (this.propertyName != null) {
            errBuilder.append(" for '" + this.propertyName + "'");
        }
        errBuilder.append('.');
        return errBuilder.toString();
    }

    protected List<String> getDefaultErrorMessages(String s) {
        return new ArrayList<String>(Collections.singleton(this.getDefaultErrorMessage(s)));
    }

    protected final List<String> getErrorMessages(String s) {
        if (this.parseErrorMessagesProvider != null) {
            return this.parseErrorMessagesProvider.getErrorMessages(s, this.propertyName);
        }
        return this.getDefaultErrorMessages(s);
    }

    protected ParseResult<T> parseAndCheck(String s) {
        ParseResult<Object> res = this.parse(s);
        if (((ParseResult)res).errorMessages == null) {
            ArrayList<String> allErrors = new ArrayList<String>();
            for (ValueChecker<Object> valueChecker : this.valueCheckers) {
                List<String> errors = valueChecker.getErrorMessages(((ParseResult)res).value, this.propertyName);
                if (errors == null) continue;
                allErrors.addAll(errors);
            }
            if (!allErrors.isEmpty()) {
                allErrors.add(0, this.getDefaultErrorMessage(s));
                res = new ParseResult<Object>(((ParseResult)res).value, allErrors);
            }
        }
        return res;
    }

    public T read(String ... prompt) {
        return this.read(Arrays.asList(prompt));
    }

    public T read(List<String> prompt) {
        String sVal;
        T value;
        this.valueListMode = false;
        this.checkConfiguration();
        TextTerminal textTerminal = this.textTerminalSupplier.get();
        do {
            this.printPrompt(prompt, textTerminal);
            sVal = textTerminal.read(this.inputMasking);
            if (sVal != null && this.inputTrimming) {
                sVal = sVal.trim();
            }
            if (sVal != null && !sVal.isEmpty() || this.defaultValue == null) continue;
            return this.defaultValue;
        } while ((value = this.getValueFromStringOrIndex(sVal, textTerminal)) == null);
        return value;
    }

    public List<T> readList(String ... prompt) {
        return this.readList(Arrays.asList(prompt));
    }

    /*
     * Could not resolve type clashes
     */
    public List<T> readList(List<String> prompt) {
        ArrayList<T> values;
        this.valueListMode = true;
        this.checkConfiguration();
        TextTerminal textTerminal = this.textTerminalSupplier.get();
        block0: while (true) {
            String[] sValues;
            this.printPrompt(prompt, textTerminal);
            String sInput = textTerminal.read(this.inputMasking);
            String[] stringArray = sValues = sInput == null ? new String[]{} : sInput.split(",");
            if (this.inputTrimming) {
                for (int i = 0; i < sValues.length; ++i) {
                    sValues[i] = sValues[i].trim();
                }
            }
            if (sValues.length == 1 && sValues[0].isEmpty()) {
                sValues = new String[]{};
            }
            if (sValues.length == 0 && this.defaultValue != null) {
                return Collections.singletonList(this.defaultValue);
            }
            values = new ArrayList<T>();
            for (String sVal : sValues) {
                T value = this.getValueFromStringOrIndex(sVal, textTerminal);
                if (value == null) continue block0;
                values.add(value);
            }
            ArrayList<String> allErrors = new ArrayList<String>();
            for (ValueChecker checker : this.valueListCheckers) {
                List<String> errors = checker.getErrorMessages(values, this.propertyName);
                if (errors == null) continue;
                allErrors.addAll(errors);
            }
            if (allErrors.isEmpty()) break;
            allErrors.add(0, this.getDefaultErrorMessage(null));
            textTerminal.println(allErrors);
            textTerminal.println();
        }
        return values;
    }

    private T getValueFromStringOrIndex(String sVal, TextTerminal textTerminal) {
        if (this.possibleValues == null || !this.numberedPossibleValues) {
            return this.getValueFromString(sVal, textTerminal);
        }
        return this.getValueFromIndex(sVal, textTerminal);
    }

    private T getValueFromString(String sVal, TextTerminal textTerminal) {
        ParseResult<T> result = this.parseAndCheck(sVal);
        List<String> errMessages = result.getErrorMessages();
        if (errMessages == null) {
            if (this.isPossibleValue(result.getValue())) {
                return result.getValue();
            }
            textTerminal.print(this.getDefaultErrorMessage(sVal));
            textTerminal.println(" You must enter one of the displayed values.");
            textTerminal.println();
        } else {
            textTerminal.println(errMessages);
            textTerminal.println();
        }
        return null;
    }

    private T getValueFromIndex(String sVal, TextTerminal textTerminal) {
        try {
            int optIndex = Integer.parseInt(sVal);
            if (optIndex > 0 && optIndex <= this.possibleValues.size()) {
                return this.possibleValues.get(optIndex - 1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        textTerminal.print(this.getDefaultErrorMessage(sVal));
        textTerminal.println(" Enter a value between 1 and " + this.possibleValues.size() + ".");
        textTerminal.println();
        return null;
    }

    protected boolean isPossibleValue(T val) {
        if (this.possibleValues == null) {
            return true;
        }
        for (T pVal : this.possibleValues) {
            if (!this.equalsFunc.apply(pVal, val).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected void checkConfiguration() throws IllegalArgumentException {
        if (this.defaultValue != null && !this.isPossibleValue(this.defaultValue)) {
            throw new IllegalArgumentException("Invalid default value: " + this.valueFormatter.apply(this.defaultValue) + ". Allowed values: " + this.possibleValues);
        }
        for (ValueChecker<T> checker : this.valueCheckers) {
            List<String> errors = null;
            if (this.defaultValue != null && (errors = checker.getErrorMessages(this.defaultValue, this.propertyName)) != null) {
                throw new IllegalArgumentException("Invalid default value: " + this.valueFormatter.apply(this.defaultValue) + ".\n" + errors);
            }
            if (this.possibleValues == null) continue;
            for (T val : this.possibleValues) {
                errors = checker.getErrorMessages(val, this.propertyName);
                if (errors == null) continue;
                throw new IllegalArgumentException("Invalid entry in the list of possible values: " + this.valueFormatter.apply(val) + ".\n" + errors);
            }
        }
    }

    protected void printPrompt(List<String> prompt, TextTerminal textTerminal) {
        textTerminal.print(prompt);
        boolean useColon = false;
        if (this.promptAdjustments && prompt != null && !prompt.isEmpty()) {
            String lastLine = prompt.get(prompt.size() - 1);
            useColon = InputReader.shouldappendColon(lastLine);
        }
        if (this.possibleValues == null) {
            if (this.promptAdjustments && this.defaultValue != null) {
                textTerminal.print(" [" + this.valueFormatter.apply(this.defaultValue) + "]: ");
            } else {
                textTerminal.print(useColon ? ": " : " ");
            }
        } else {
            textTerminal.println(useColon ? ":" : "");
            for (int i = 0; i < this.possibleValues.size(); ++i) {
                T option = this.possibleValues.get(i);
                boolean isDefault = this.defaultValue != null && this.equalsFunc.apply(this.defaultValue, option) != false;
                textTerminal.println((isDefault ? "* " : "  ") + (this.numberedPossibleValues ? i + 1 + ": " : "") + this.valueFormatter.apply(option));
            }
            textTerminal.print(this.valueListMode ? "Enter your choices as comma-separated values: " : "Enter your choice: ");
        }
    }

    private static boolean shouldappendColon(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        char lastChar = s.charAt(s.length() - 1);
        return "()[]{}.,;:?!".indexOf(lastChar) > 0 || Character.isJavaIdentifierPart(lastChar);
    }

    public static <T> ValueChecker<List<T>> nonEmptyListChecker() {
        return (list, propName) -> {
            if (list == null || list.isEmpty()) {
                return Collections.singletonList("Expected at least one element.");
            }
            return null;
        };
    }

    public static <T> ValueChecker<List<T>> noDuplicatesChecker() {
        return (list, propName) -> {
            if (list == null || list.size() < 2) {
                return null;
            }
            HashSet valueSet = new HashSet(list);
            if (valueSet.size() < list.size()) {
                return Collections.singletonList("Duplicate values are not allowed.");
            }
            return null;
        };
    }

    public static class ParseResult<T> {
        private final T value;
        private final List<String> errorMessages;

        public ParseResult(T value) {
            this.value = value;
            this.errorMessages = null;
        }

        public ParseResult(T value, List<String> errorMessages) {
            this.value = value;
            this.errorMessages = errorMessages != null && errorMessages.isEmpty() ? null : errorMessages;
        }

        public ParseResult(T value, String ... errorMessages) {
            this.value = value;
            this.errorMessages = errorMessages.length == 0 ? null : Arrays.asList(errorMessages);
        }

        public T getValue() {
            return this.value;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }
    }

    @FunctionalInterface
    public static interface ValueChecker<T> {
        public List<String> getErrorMessages(T var1, String var2);
    }

    @FunctionalInterface
    public static interface ErrorMessagesProvider {
        public List<String> getErrorMessages(String var1, String var2);
    }
}

