/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextTerminal;

public class StringInputReader
extends InputReader<String, StringInputReader> {
    private Pattern pattern;
    private int minLength = 1;
    private int maxLength = -1;

    public StringInputReader(Supplier<TextTerminal> textTerminalSupplier) {
        super(textTerminalSupplier);
        this.numberedPossibleValues = true;
        this.valueCheckers.add((val, propName) -> this.getLengthValidationErrors((String)val));
        this.valueCheckers.add((val, propName) -> this.getPatternValidationErrors((String)val));
    }

    public StringInputReader withPattern(String regex) {
        this.pattern = regex == null ? null : Pattern.compile(regex);
        return this;
    }

    public StringInputReader withPattern(String regex, int flags) {
        this.pattern = regex == null ? null : Pattern.compile(regex, flags);
        return this;
    }

    public StringInputReader withMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public StringInputReader withMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Override
    protected InputReader.ParseResult<String> parse(String s) {
        return new InputReader.ParseResult<String>(s);
    }

    @Override
    protected void checkConfiguration() throws IllegalArgumentException {
        super.checkConfiguration();
        if (this.minLength > 0 && this.maxLength > 0 && this.minLength > this.maxLength) {
            throw new IllegalArgumentException("minLength = " + this.minLength + ", maxLength = " + this.maxLength);
        }
    }

    protected List<String> getLengthValidationErrors(String s) {
        int len = s == null ? 0 : s.length();
        IntFunction<String> chr = l -> l + " character" + (l > 1 ? "s." : ".");
        if (this.minLength > 0 && this.minLength > len) {
            return Collections.singletonList("Expected a string with at least " + chr.apply(this.minLength));
        }
        if (this.maxLength > 0 && this.maxLength < len) {
            return Collections.singletonList("Expected a string with at most " + chr.apply(this.maxLength));
        }
        return null;
    }

    protected List<String> getPatternValidationErrors(String s) {
        if (this.pattern != null && !this.pattern.matcher(s).matches()) {
            return Collections.singletonList("Expected format: " + this.pattern.pattern());
        }
        return null;
    }
}

