/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.beryx.textio.InputReader;
import org.beryx.textio.TextTerminal;

public class EnumInputReader<T extends Enum<T>>
extends InputReader<T, EnumInputReader<T>> {
    private final Map<String, T> enumValues = new LinkedHashMap<String, T>();

    public EnumInputReader(Supplier<TextTerminal> textTerminalSupplier, Class<T> enumClass) {
        super(textTerminalSupplier);
        try {
            Enum[] values;
            Method mValues = enumClass.getMethod("values", new Class[0]);
            for (Enum value : values = (Enum[])mValues.invoke(null, new Object[0])) {
                this.enumValues.put(value.toString(), value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create EnumInputReader<" + enumClass.getName() + ">", e);
        }
        this.possibleValues = new ArrayList<T>(this.enumValues.values());
        this.numberedPossibleValues = true;
    }

    @Override
    public EnumInputReader<T> withPossibleValues(T ... possibleValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EnumInputReader<T> withPossibleValues(List<T> possibleValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected InputReader.ParseResult<T> parse(String s) {
        Enum value = (Enum)this.enumValues.get(s);
        if (value != null) {
            return new InputReader.ParseResult<Enum>(value);
        }
        return new InputReader.ParseResult<Object>(null, this.getErrorMessages(s));
    }
}

