/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.beryx.textio.TextTerminal;

public class SwingTextTerminal
implements TextTerminal {
    private final JFrame frame;
    private final JTextArea textArea;
    private String extendedPrompt = "";
    private String unmaskedContent = "";
    private final Object editLock = new Object();
    private volatile boolean readMode = false;
    private volatile boolean writeMode = false;
    private volatile boolean inputMasking = false;
    private volatile String input;
    private boolean initialized = false;

    public SwingTextTerminal() {
        this.frame = new JFrame("Text Terminal");
        this.textArea = new JTextArea(30, 80);
        this.textArea.setLineWrap(true);
        this.textArea.setBackground(Color.black);
        this.textArea.setForeground(Color.green);
        this.textArea.setCaretColor(Color.green);
        this.textArea.setFont(new Font("Courier New", 0, 15));
        ((AbstractDocument)this.textArea.getDocument()).setDocumentFilter(new TerminalDocumentFilter());
        JScrollPane scroll = new JScrollPane(this.textArea, 20, 30);
        this.frame.add(scroll);
        this.frame.setDefaultCloseOperation(0);
        WindowAdapter exitListener = new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                Object object = SwingTextTerminal.this.editLock;
                synchronized (object) {
                    if (SwingTextTerminal.this.readMode || SwingTextTerminal.this.writeMode) {
                        return;
                    }
                }
                SwingTextTerminal.this.frame.dispose();
            }
        };
        this.frame.addWindowListener(exitListener);
        this.frame.add(scroll);
        this.frame.pack();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String read(boolean masking) {
        this.display();
        try {
            Object object = this.editLock;
            synchronized (object) {
                try {
                    this.input = null;
                    this.inputMasking = masking;
                    this.readMode = true;
                    while (this.input == null) {
                        this.editLock.wait();
                    }
                    String string = this.input;
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("read interrupted", e);
                    }
                }
            }
        }
        finally {
            Object object = this.editLock;
            synchronized (object) {
                this.inputMasking = false;
                this.readMode = false;
            }
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rawPrint(String message) {
        Object object;
        this.display();
        try {
            object = this.editLock;
            synchronized (object) {
                this.writeMode = true;
                this.textArea.append(message);
                this.extendedPrompt = this.textArea.getText();
                this.textArea.setCaretPosition(this.extendedPrompt.length());
            }
        }
        finally {
            object = this.editLock;
            synchronized (object) {
                this.writeMode = false;
            }
        }
    }

    @Override
    public void println() {
        this.rawPrint("\n");
    }

    public void display() {
        if (!this.initialized) {
            this.initialized = true;
            this.frame.pack();
        }
        this.frame.setVisible(true);
    }

    @Override
    public void dispose() {
        this.frame.dispose();
    }

    private class TerminalDocumentFilter
    extends DocumentFilter {
        private TerminalDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
            this.changeText(fb, attrs, offset, text, t -> super.insertString(fb, offset, t, attrs));
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            this.changeText(fb, attrs, offset, text, t -> super.replace(fb, offset, length, t, attrs));
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            this.changeText(fb, null, offset, null, t -> super.remove(fb, offset, length));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changeText(DocumentFilter.FilterBypass fb, AttributeSet attrs, int offset, String text, TextChanger textChanger) throws BadLocationException {
            Object object = SwingTextTerminal.this.editLock;
            synchronized (object) {
                if (this.isEditAllowedAt(offset)) {
                    Document doc = fb.getDocument();
                    int pos = -1;
                    if (text != null && SwingTextTerminal.this.readMode && (pos = text.indexOf("\n")) >= 0) {
                        text = text.substring(0, pos);
                    }
                    try {
                        if (SwingTextTerminal.this.readMode && SwingTextTerminal.this.inputMasking) {
                            textChanger.changeText(text);
                            int caretPosition = SwingTextTerminal.this.textArea.getCaretPosition();
                            fb.remove(0, doc.getLength());
                            fb.insertString(0, SwingTextTerminal.this.unmaskedContent, attrs);
                            textChanger.changeText(text);
                            SwingTextTerminal.this.unmaskedContent = doc.getText(0, doc.getLength());
                            this.maskContent(fb, attrs);
                            SwingTextTerminal.this.textArea.setCaretPosition(caretPosition);
                        } else {
                            textChanger.changeText(text);
                            SwingTextTerminal.this.unmaskedContent = doc.getText(0, doc.getLength());
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof BadLocationException) {
                            throw (BadLocationException)e;
                        }
                        throw new BadLocationException(e.toString(), offset);
                    }
                    if (pos >= 0) {
                        SwingTextTerminal.this.input = SwingTextTerminal.this.unmaskedContent.substring(SwingTextTerminal.this.extendedPrompt.length());
                        SwingTextTerminal.this.unmaskedContent = doc.getText(0, doc.getLength());
                        SwingTextTerminal.this.editLock.notifyAll();
                    }
                }
            }
        }

        private void maskContent(DocumentFilter.FilterBypass fb, AttributeSet attrs) throws BadLocationException {
            StringBuilder maskedSb = new StringBuilder(SwingTextTerminal.this.extendedPrompt);
            int maskedLen = SwingTextTerminal.this.unmaskedContent.length() - SwingTextTerminal.this.extendedPrompt.length();
            for (int i = 0; i < maskedLen; ++i) {
                maskedSb.append('*');
            }
            fb.remove(0, fb.getDocument().getLength());
            fb.insertString(0, maskedSb.toString(), attrs);
        }

        private boolean isEditAllowedAt(int offset) {
            return (SwingTextTerminal.this.readMode || SwingTextTerminal.this.writeMode) && SwingTextTerminal.this.textArea.getCaretPosition() >= SwingTextTerminal.this.extendedPrompt.length() && offset >= SwingTextTerminal.this.extendedPrompt.length();
        }
    }

    @FunctionalInterface
    private static interface TextChanger {
        public void changeText(String var1) throws BadLocationException;
    }
}

