/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.demo;

import java.time.Month;
import org.beryx.textio.IntInputReader;
import org.beryx.textio.StringInputReader;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextIoFactory;
import org.beryx.textio.TextTerminal;

public class TextIoDemo {
    public static void main(String[] args) {
        if (args.length > 0) {
            System.setProperty("org.beryx.textio.TextTerminal", args[0]);
        }
        TextIO textIO = TextIoFactory.getTextIO();
        TextTerminal terminal = textIO.getTextTerminal();
        if (args.length == 0) {
            terminal.println("-------------------------------------------------------------------------");
            terminal.println("Usage tip:");
            terminal.println("  Provide as argument the fully-qualified name of a TextTerminal class.");
            terminal.println("  Example: run with the argument org.beryx.textio.demo.ColorTextTerminal.");
            terminal.println("-------------------------------------------------------------------------");
            terminal.println();
            terminal.println();
        }
        String user = (String)((StringInputReader)textIO.newStringInputReader().withDefaultValue("admin")).read("Username");
        String password = (String)((StringInputReader)textIO.newStringInputReader().withMinLength(6).withInputMasking(true)).read("Password");
        int age = (Integer)((IntInputReader)textIO.newIntInputReader().withMinVal(13)).read("Age");
        Month month = (Month)textIO.newEnumInputReader(Month.class).read("What month were you born in?");
        terminal.printf("\nUser %s is %d years old, was born in %s and has the password %s.\n", user, age, month, password);
        textIO.newStringInputReader().withMinLength(0).read("\nPress enter to terminate...");
        textIO.dispose();
    }
}

