/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public interface TextTerminal {
    public String read(boolean var1);

    public void rawPrint(String var1);

    public void println();

    default public void dispose() {
    }

    default public void rawPrint(List<String> messages) {
        if (messages != null && !messages.isEmpty()) {
            this.rawPrint(messages.get(0));
            messages.subList(1, messages.size()).forEach(msg -> {
                this.println();
                this.print((String)msg);
            });
        }
    }

    default public void print(String message) {
        List<String> messages = Arrays.asList(message.split("\\R", -1));
        this.rawPrint(messages);
    }

    default public void println(String message) {
        this.print(message);
        this.println();
    }

    default public void print(List<String> messages) {
        if (messages == null) {
            return;
        }
        List<String> rawMessages = messages.stream().flatMap(msg -> Arrays.stream(msg.split("\\R", -1))).collect(Collectors.toList());
        this.rawPrint(rawMessages);
    }

    default public void println(List<String> messages) {
        this.print(messages);
        this.println();
    }

    default public void printf(String format, Object ... args) {
        this.print(String.format(format, args));
    }

    default public void printf(Locale l, String format, Object ... args) {
        this.print(String.format(l, format, args));
    }
}

