/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.jline;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import jline.console.ConsoleReader;
import org.beryx.textio.jline.JLineTextTerminal;

public class AnsiTextTerminal
extends JLineTextTerminal {
    private static String ANSI_RESET = "\u001b[0m";
    private static String ANSI_BOLD = "\u001b[1m";
    public static Map<String, Integer> ANSI_COLOR_MAP = new LinkedHashMap<String, Integer>();
    private String ansiColor = AnsiTextTerminal.getAnsiColor("green");
    private String ansiBackgroundColor = "";
    private boolean bold = false;

    public static int getColorCode(String colorName) {
        return ANSI_COLOR_MAP.getOrDefault(colorName.toLowerCase(), -1);
    }

    public static String getAnsiColor(String colorName) {
        int color = AnsiTextTerminal.getColorCode(colorName);
        return color < 0 ? "" : "\u001b[1;3" + color + "m";
    }

    public static String getAnsiBackgroundColor(String colorName) {
        int color = AnsiTextTerminal.getColorCode(colorName);
        return color < 0 ? "" : "\u001b[1;4" + color + "m";
    }

    private static ConsoleReader createReader() {
        try {
            if (System.console() == null) {
                throw new IllegalArgumentException("Console not available.");
            }
            return new ConsoleReader();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create a JLine ConsoleReader.", e);
        }
    }

    public AnsiTextTerminal() {
        super(AnsiTextTerminal.createReader());
    }

    public AnsiTextTerminal withColor(String colorName) {
        this.ansiColor = AnsiTextTerminal.getAnsiColor(colorName);
        return this;
    }

    public AnsiTextTerminal withBackgroundColor(String colorName) {
        this.ansiBackgroundColor = AnsiTextTerminal.getAnsiBackgroundColor(colorName);
        return this;
    }

    public AnsiTextTerminal withBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    @Override
    public void rawPrint(String message) {
        super.rawPrint(this.ansiColor + this.ansiBackgroundColor + (this.bold ? ANSI_BOLD : "") + message + ANSI_RESET);
    }

    static {
        ANSI_COLOR_MAP.put("default", -1);
        ANSI_COLOR_MAP.put("black", 0);
        ANSI_COLOR_MAP.put("red", 1);
        ANSI_COLOR_MAP.put("green", 2);
        ANSI_COLOR_MAP.put("yellow", 3);
        ANSI_COLOR_MAP.put("blue", 4);
        ANSI_COLOR_MAP.put("magenta", 5);
        ANSI_COLOR_MAP.put("cyan", 6);
        ANSI_COLOR_MAP.put("white", 7);
    }
}

