/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.jline;

import java.io.IOException;
import jline.console.ConsoleReader;
import org.beryx.textio.TextTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JLineTextTerminal
implements TextTerminal {
    private static final Logger logger = LoggerFactory.getLogger(JLineTextTerminal.class);
    private final ConsoleReader reader;

    public JLineTextTerminal(ConsoleReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.reader = reader;
    }

    @Override
    public String read(boolean masking) {
        Character mask = masking ? Character.valueOf('*') : null;
        try {
            return this.reader.readLine(mask);
        }
        catch (IOException e) {
            logger.error("read error.", (Throwable)e);
            return "";
        }
    }

    @Override
    public void rawPrint(String message) {
        try {
            this.reader.setPrompt(message);
            this.reader.drawLine();
            this.reader.flush();
        }
        catch (IOException e) {
            logger.error("print error.", (Throwable)e);
        }
        finally {
            this.reader.setPrompt(null);
        }
    }

    @Override
    public void println() {
        try {
            this.reader.println();
            this.reader.flush();
        }
        catch (IOException e) {
            logger.error("println error.", (Throwable)e);
        }
    }

    public ConsoleReader getReader() {
        return this.reader;
    }
}

