/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.console;

import java.io.Console;
import org.beryx.textio.TextTerminal;

public class ConsoleTextTerminal
implements TextTerminal {
    private final Console console;

    public ConsoleTextTerminal() {
        this(System.console());
    }

    public ConsoleTextTerminal(Console console) {
        if (console == null) {
            throw new IllegalArgumentException("console is null");
        }
        this.console = console;
    }

    @Override
    public String read(boolean masking) {
        if (masking) {
            char[] chars = this.console.readPassword();
            return chars == null ? null : new String(chars);
        }
        return this.console.readLine();
    }

    @Override
    public void rawPrint(String message) {
        this.console.printf(message, new Object[0]);
        this.console.flush();
    }

    @Override
    public void println() {
        this.console.printf("\n", new Object[0]);
        this.console.flush();
    }
}

