/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.swing;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import org.beryx.textio.TextTerminal;
import org.beryx.textio.TextTerminalProvider;
import org.beryx.textio.swing.SwingTextTerminal;

public class SwingTextTerminalProvider
implements TextTerminalProvider {
    @Override
    public TextTerminal getTextTerminal() {
        if (SwingTextTerminalProvider.isHeadless()) {
            return null;
        }
        return new SwingTextTerminal();
    }

    private static boolean isHeadless() {
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        try {
            GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            return screenDevices == null || screenDevices.length == 0;
        }
        catch (HeadlessException e) {
            return true;
        }
    }

    public String toString() {
        return "Swing terminal";
    }
}

