/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.beryx.textio.PropertiesPrefixes;
import org.beryx.textio.TerminalProperties;
import org.beryx.textio.TextTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PropertiesPrefixes(value={"textio"})
public abstract class AbstractTextTerminal<T extends AbstractTextTerminal<T>>
implements TextTerminal<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTextTerminal.class);
    public static final String SYSPROP_PROPERTIES_FILE_LOCATION = "textio.properties.location";
    public static final String DEFAULT_USER_INTERRUPT_KEY = "ctrl C";
    private final TerminalProperties<T> properties;
    private final Map<String, String> defaultProperties = new HashMap<String, String>();
    private boolean initialized = false;

    public AbstractTextTerminal() {
        this.properties = new TerminalProperties<AbstractTextTerminal>(this);
        this.addDefaultProperty("user.interrupt.key", DEFAULT_USER_INTERRUPT_KEY);
    }

    @Override
    public TerminalProperties<T> getProperties() {
        return this.properties;
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initProperties();
    }

    public List<String> getPropertiesPrefixes() {
        return this.getPropertiesPrefixes(this.getClass());
    }

    private List<String> getPropertiesPrefixes(Class<?> cls) {
        if (cls == null || !TextTerminal.class.isAssignableFrom(cls)) {
            return Collections.emptyList();
        }
        List<String> superPrefixes = this.getPropertiesPrefixes(cls.getSuperclass());
        PropertiesPrefixes annotation = cls.getAnnotation(PropertiesPrefixes.class);
        if (annotation == null) {
            return superPrefixes;
        }
        List<String> prefixes = Arrays.asList(annotation.value());
        if (superPrefixes.isEmpty()) {
            return prefixes;
        }
        ArrayList<String> allPrefixes = new ArrayList<String>(superPrefixes);
        allPrefixes.addAll(prefixes);
        return allPrefixes;
    }

    public final Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public final String addDefaultProperty(String key, String value) {
        return this.defaultProperties.put(key, value);
    }

    public void initProperties() {
        this.initProperties((Reader)this.getPropertiesReader().orElse(null));
    }

    public Optional<Reader> getPropertiesReader() {
        File propsFile;
        String propsPath = System.getProperty(SYSPROP_PROPERTIES_FILE_LOCATION, null);
        if (propsPath != null) {
            logger.debug("Found system property {} with value: {}", (Object)SYSPROP_PROPERTIES_FILE_LOCATION, (Object)propsPath);
            if (!new File(propsPath).isAbsolute()) {
                propsPath = System.getProperty("user.dir") + "/" + propsPath;
            }
        } else {
            logger.debug("System property {} not set.", (Object)SYSPROP_PROPERTIES_FILE_LOCATION);
            propsPath = System.getProperty("user.dir") + "/textio.properties";
        }
        if ((propsFile = new File(propsPath)).exists()) {
            try {
                FileReader reader = new FileReader(propsFile);
                logger.debug("Found terminal properties file {}", (Object)propsFile.getAbsolutePath());
                return Optional.of(reader);
            }
            catch (FileNotFoundException e) {
                logger.warn("Cannot read terminal properties from {}", (Object)propsFile.getAbsolutePath(), (Object)e);
            }
        } else {
            logger.debug("Terminal properties file {} not found.", (Object)propsFile.getAbsolutePath());
        }
        URL propsResource = this.getClass().getResource("/textio.properties");
        if (propsResource != null) {
            logger.debug("Found terminal properties file in classpath: {}", (Object)propsResource);
            try {
                return Optional.of(new InputStreamReader(propsResource.openStream()));
            }
            catch (IOException e) {
                logger.warn("Cannot read terminal properties from " + propsResource, (Throwable)e);
            }
        } else {
            logger.debug("No terminal properties file found in classpath.");
        }
        logger.debug("Using only default properties.");
        return Optional.empty();
    }

    public void initProperties(Reader propsReader) {
        Properties rawProps = new Properties();
        if (propsReader != null) {
            try {
                rawProps.load(propsReader);
            }
            catch (IOException e) {
                logger.warn("Failed to read terminal properties.", (Throwable)e);
            }
        }
        this.initProperties(rawProps);
    }

    public void initProperties(Properties rawProps) {
        HashMap<String, String> props = new HashMap<String, String>(this.defaultProperties);
        for (String pp : this.getPropertiesPrefixes()) {
            String prefix = pp + ".";
            int prefixLen = prefix.length();
            for (String key : rawProps.stringPropertyNames()) {
                if (!(key = key.trim()).startsWith(prefix)) continue;
                String value = rawProps.getProperty(key);
                if (value != null) {
                    value = value.trim();
                }
                props.put(key.substring(prefixLen), value);
            }
        }
        this.properties.putAll(props);
    }
}

