/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.beryx.textio.AbstractTextTerminal;
import org.beryx.textio.PropertiesPrefixes;
import org.beryx.textio.TerminalProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PropertiesPrefixes(value={"swing"})
public class SwingTextTerminal
extends AbstractTextTerminal<SwingTextTerminal> {
    private static final Logger logger = LoggerFactory.getLogger(SwingTextTerminal.class);
    private static final String ZERO_WIDTH_SPACE = "\u200b";
    public static final int DEFAULT_FONT_SIZE = 15;
    public static final Color DEFAULT_PANE_BACKGROUND = Color.black;
    public static final Color DEFAULT_PROMPT_COLOR = Color.green;
    public static final Color DEFAULT_INPUT_COLOR = Color.green;
    private final JFrame frame;
    private final JTextPane textPane;
    private final JScrollPane scrollPane;
    private String unmaskedInput = "";
    private int startReadLen;
    private int startLineOffset;
    private final Map<String, Integer> bookmarkOffsets = new HashMap<String, Integer>();
    private final Object editLock = new Object();
    private volatile boolean readMode = false;
    private volatile boolean inputMasking = false;
    private volatile String input;
    private Consumer<SwingTextTerminal> userInterruptHandler = textTerm -> System.exit(-1);
    private final Action userInterruptAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SwingTextTerminal.this.userInterruptHandler != null) {
                SwingTextTerminal.this.userInterruptHandler.accept(SwingTextTerminal.this);
            }
        }
    };
    private boolean initialized = false;
    private final StyledDocument document;
    private final StyleData promptStyleData = new StyleData();
    private final StyleData inputStyleData = new StyleData();
    private int styleCount = 0;

    public SwingTextTerminal() {
        TerminalProperties<SwingTextTerminal> props = this.getProperties();
        props.addStringListener("user.interrupt.key", null, (term, newVal) -> this.setUserInterruptKey(newVal));
        props.addStringListener("pane.width", null, (term, newVal) -> this.updateScrollPaneSize(true));
        props.addStringListener("pane.height", null, (term, newVal) -> this.updateScrollPaneSize(true));
        props.addStringListener("pane.bgcolor", null, (term, newVal) -> this.setPaneBackgroundColor(newVal));
        props.addStringListener("pane.title", null, (term, newVal) -> this.setPaneTitle(newVal));
        props.addStringListener("pane.icon.url", null, (term, newVal) -> this.setPaneIconUrl(newVal));
        props.addStringListener("pane.icon.file", null, (term, newVal) -> this.setPaneIconFile(newVal));
        props.addStringListener("pane.icon.resource", null, (term, newVal) -> this.setPaneIconResource(newVal));
        props.addStringListener("prompt.color", null, (term, newVal) -> this.setPromptColor(newVal));
        props.addStringListener("prompt.bgcolor", null, (term, newVal) -> this.setPromptBackgroundColor(newVal));
        props.addStringListener("prompt.font.family", null, (term, newVal) -> this.setPromptFontFamily(newVal));
        props.addIntListener("prompt.font.size", 15, (term, newVal) -> this.setPromptFontSize(newVal));
        props.addBooleanListener("prompt.bold", false, (term, newVal) -> this.setPromptBold(newVal));
        props.addBooleanListener("prompt.italic", false, (term, newVal) -> this.setPromptItalic(newVal));
        props.addBooleanListener("prompt.underline", false, (term, newVal) -> this.setPromptUnderline(newVal));
        props.addBooleanListener("prompt.subscript", false, (term, newVal) -> this.setPromptSubscript(newVal));
        props.addBooleanListener("prompt.superscript", false, (term, newVal) -> this.setPromptSuperscript(newVal));
        props.addStringListener("input.color", null, (term, newVal) -> this.setInputColor(newVal));
        props.addStringListener("input.bgcolor", null, (term, newVal) -> this.setInputBackgroundColor(newVal));
        props.addStringListener("input.font.family", null, (term, newVal) -> this.setInputFontFamily(newVal));
        props.addIntListener("input.font.size", 15, (term, newVal) -> this.setInputFontSize(newVal));
        props.addBooleanListener("input.bold", false, (term, newVal) -> this.setInputBold(newVal));
        props.addBooleanListener("input.italic", false, (term, newVal) -> this.setInputItalic(newVal));
        props.addBooleanListener("input.underline", false, (term, newVal) -> this.setInputUnderline(newVal));
        props.addBooleanListener("input.subscript", false, (term, newVal) -> this.setInputSubscript(newVal));
        props.addBooleanListener("input.superscript", false, (term, newVal) -> this.setInputSuperscript(newVal));
        this.frame = new JFrame("Text Terminal");
        this.textPane = new JTextPane();
        this.textPane.setBackground(DEFAULT_PANE_BACKGROUND);
        this.promptStyleData.color = DEFAULT_PROMPT_COLOR;
        this.inputStyleData.color = DEFAULT_INPUT_COLOR;
        this.textPane.setCaretColor(this.inputStyleData.color);
        this.document = this.textPane.getStyledDocument();
        ((AbstractDocument)((Object)this.document)).setDocumentFilter(new TerminalDocumentFilter());
        this.scrollPane = new JScrollPane(this.textPane, 20, 30);
        this.updateScrollPaneSize(false);
        this.scrollPane.setMinimumSize(new Dimension(40, 40));
        this.frame.add(this.scrollPane);
        this.frame.setDefaultCloseOperation(0);
        WindowAdapter exitListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SwingTextTerminal.this.userInterruptHandler != null) {
                    SwingTextTerminal.this.userInterruptHandler.accept(SwingTextTerminal.this);
                }
            }
        };
        this.frame.addWindowListener(exitListener);
        this.frame.add(this.scrollPane);
        this.frame.pack();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String read(boolean masking) {
        this.rawPrint(ZERO_WIDTH_SPACE, this.inputStyleData);
        this.display();
        try {
            Object object = this.editLock;
            synchronized (object) {
                try {
                    this.startReadLen = this.document.getLength();
                    this.unmaskedInput = "";
                    this.input = null;
                    this.inputMasking = masking;
                    this.readMode = true;
                    while (this.input == null) {
                        this.editLock.wait();
                    }
                    String string = this.input;
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("read interrupted", e);
                    }
                }
            }
        }
        finally {
            Object object = this.editLock;
            synchronized (object) {
                this.inputMasking = false;
                this.readMode = false;
            }
            this.rawPrint("\n", this.inputStyleData);
        }
    }

    @Override
    public void rawPrint(String message) {
        this.rawPrint(message, this.promptStyleData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rawPrint(String message, StyleData styleData) {
        this.display();
        Object object = this.editLock;
        synchronized (object) {
            String styleName = this.getStyle(styleData);
            try {
                this.document.insertString(this.document.getLength(), message, this.document.getStyle(styleName));
            }
            catch (BadLocationException e) {
                logger.error("Cannot insert string", (Throwable)e);
            }
            this.textPane.setCaretPosition(this.document.getLength());
        }
    }

    @Override
    public void println() {
        this.rawPrint("\n");
        this.startLineOffset = this.document.getLength();
    }

    @Override
    public boolean resetLine() {
        return this.resetToOffset(this.startLineOffset);
    }

    @Override
    public boolean setBookmark(String bookmark) {
        this.bookmarkOffsets.put(bookmark, this.document.getLength());
        return true;
    }

    @Override
    public boolean resetToBookmark(String bookmark) {
        int offset = this.getBookmarkOffset(bookmark);
        return this.resetToOffset(offset);
    }

    public int getBookmarkOffset(String bookmark) {
        return this.bookmarkOffsets.getOrDefault(bookmark, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetToOffset(int offset) {
        if (offset < 0) {
            return false;
        }
        this.display();
        Object object = this.editLock;
        synchronized (object) {
            boolean result = true;
            int len = this.document.getLength() - offset;
            if (len > 0) {
                int oldStartReadLen = this.startReadLen;
                if (this.startReadLen > offset) {
                    this.startReadLen = offset;
                }
                try {
                    this.document.remove(offset, len);
                }
                catch (BadLocationException e) {
                    logger.error("Cannot reset to offset " + offset, (Throwable)e);
                    this.startReadLen = oldStartReadLen;
                    result = false;
                }
                this.textPane.setCaretPosition(this.document.getLength());
            }
            return result;
        }
    }

    public void display() {
        if (!this.initialized) {
            this.initialized = true;
            this.frame.pack();
        }
        if (!this.frame.isVisible()) {
            this.frame.setVisible(true);
        }
    }

    @Override
    public void dispose(String resultData) {
        this.frame.dispose();
        if (resultData != null && !resultData.isEmpty()) {
            logger.info("Disposed with resultData: {}.", (Object)resultData);
        }
    }

    @Override
    public boolean registerUserInterruptHandler(Consumer<SwingTextTerminal> handler, boolean abortRead) {
        this.userInterruptHandler = handler;
        return true;
    }

    public void setUserInterruptKey(KeyStroke keyStroke) {
        String userInterruptActionKey = "SwingTextTerminal.userInterrupt";
        this.textPane.getInputMap().put(keyStroke, userInterruptActionKey);
        this.textPane.getActionMap().put(userInterruptActionKey, this.userInterruptAction);
    }

    public void setUserInterruptKey(String keyStroke) {
        this.setUserInterruptKey(KeyStroke.getKeyStroke(keyStroke));
    }

    public String getStyle(StyleData styleData) {
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        ++this.styleCount;
        String styleName = "style-" + this.styleCount;
        Style style = this.document.addStyle(styleName, defaultStyle);
        if (styleData.fontFamily != null) {
            StyleConstants.setFontFamily(style, styleData.fontFamily);
        }
        if (styleData.fontSize > 0) {
            StyleConstants.setFontSize(style, styleData.fontSize);
        }
        if (styleData.color != null) {
            StyleConstants.setForeground(style, styleData.color);
        }
        if (styleData.bgColor != null) {
            StyleConstants.setBackground(style, styleData.bgColor);
        }
        StyleConstants.setBold(style, styleData.bold);
        StyleConstants.setItalic(style, styleData.italic);
        StyleConstants.setUnderline(style, styleData.underline);
        StyleConstants.setStrikeThrough(style, styleData.strikeThrough);
        StyleConstants.setSubscript(style, styleData.subscript);
        StyleConstants.setSuperscript(style, styleData.superscript);
        return styleName;
    }

    public void setPromptColor(String colorName) {
        SwingTextTerminal.getColor(colorName).ifPresent(col -> {
            this.promptStyleData.color = col;
        });
    }

    public void setPromptBackgroundColor(String colorName) {
        SwingTextTerminal.getColor(colorName).ifPresent(col -> {
            this.promptStyleData.bgColor = col;
        });
    }

    public void setPromptFontFamily(String fontFamily) {
        this.promptStyleData.fontFamily = fontFamily;
    }

    public void setPromptFontSize(int fontSize) {
        this.promptStyleData.fontSize = fontSize;
    }

    public void setPromptBold(boolean bold) {
        this.promptStyleData.bold = bold;
    }

    public void setPromptItalic(boolean italic) {
        this.promptStyleData.italic = italic;
    }

    public void setPromptUnderline(boolean underline) {
        this.promptStyleData.underline = underline;
    }

    public void setPromptSubscript(boolean subscript) {
        this.promptStyleData.subscript = subscript;
    }

    public void setPromptSuperscript(boolean superscript) {
        this.promptStyleData.superscript = superscript;
    }

    public void setInputColor(String colorName) {
        SwingTextTerminal.getColor(colorName).ifPresent(col -> {
            this.inputStyleData.color = col;
            this.textPane.setCaretColor(this.inputStyleData.color);
        });
    }

    public void setInputBackgroundColor(String colorName) {
        SwingTextTerminal.getColor(colorName).ifPresent(col -> {
            this.inputStyleData.bgColor = col;
        });
    }

    public void setInputFontFamily(String fontFamily) {
        this.inputStyleData.fontFamily = fontFamily;
    }

    public void setInputFontSize(int fontSize) {
        this.inputStyleData.fontSize = fontSize;
    }

    public void setInputBold(boolean bold) {
        this.inputStyleData.bold = bold;
    }

    public void setInputItalic(boolean italic) {
        this.inputStyleData.italic = italic;
    }

    public void setInputUnderline(boolean underline) {
        this.inputStyleData.underline = underline;
    }

    public void setInputSubscript(boolean subscript) {
        this.inputStyleData.subscript = subscript;
    }

    public void setInputSuperscript(boolean superscript) {
        this.inputStyleData.superscript = superscript;
    }

    public void setPaneBackgroundColor(String colorName) {
        SwingTextTerminal.getColor(colorName).ifPresent(this.textPane::setBackground);
    }

    public void setPaneTitle(String newTitle) {
        this.frame.setTitle(newTitle);
    }

    public void setPaneIconUrl(String url) {
        try {
            this.frame.setIconImage(ImageIO.read(new URL(url)));
        }
        catch (IOException e) {
            logger.warn("Cannot set icon from URL " + url, (Throwable)e);
        }
    }

    public void setPaneIconFile(String filePath) {
        try {
            this.frame.setIconImage(ImageIO.read(new File(filePath)));
        }
        catch (IOException e) {
            logger.warn("Cannot set icon from file " + filePath, (Throwable)e);
        }
    }

    public void setPaneIconResource(String res) {
        InputStream istream = this.getClass().getResourceAsStream(res);
        if (istream == null) {
            logger.warn("Cannot find icon resource " + res);
        } else {
            try {
                this.frame.setIconImage(ImageIO.read(istream));
            }
            catch (IOException e) {
                logger.warn("Cannot set icon from resource " + res, (Throwable)e);
            }
        }
    }

    protected void updateScrollPaneSize(boolean pack) {
        TerminalProperties props = this.getProperties();
        int w = props.getInt("pane.width", 640);
        int h = props.getInt("pane.height", 480);
        this.scrollPane.setPreferredSize(new Dimension(w, h));
        if (pack) {
            this.frame.pack();
        }
    }

    public static Optional<Color> getColor(String colorName) {
        try {
            javafx.scene.paint.Color fxColor = javafx.scene.paint.Color.web((String)colorName);
            return Optional.of(new Color((float)fxColor.getRed(), (float)fxColor.getGreen(), (float)fxColor.getBlue(), (float)fxColor.getOpacity()));
        }
        catch (Exception e) {
            logger.warn("Invalid color: {}", (Object)colorName);
            return Optional.empty();
        }
    }

    private class TerminalDocumentFilter
    extends DocumentFilter {
        private TerminalDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
            this.changeText(fb, attrs, offset, text, t -> super.insertString(fb, offset, t, attrs));
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            this.changeText(fb, attrs, offset, text, t -> super.replace(fb, offset, length, t, attrs));
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            this.changeText(fb, null, offset, null, t -> super.remove(fb, offset, length));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changeText(DocumentFilter.FilterBypass fb, AttributeSet attrs, int offset, String text, TextChanger textChanger) throws BadLocationException {
            Object object = SwingTextTerminal.this.editLock;
            synchronized (object) {
                if (this.isEditAllowedAt(offset)) {
                    Document doc = fb.getDocument();
                    int pos = -1;
                    if (text != null && SwingTextTerminal.this.readMode && (pos = text.indexOf("\n")) >= 0) {
                        text = text.substring(0, pos);
                    }
                    try {
                        textChanger.changeText(text);
                        int newUnmaskedInputLen = doc.getLength() - SwingTextTerminal.this.startReadLen;
                        if (SwingTextTerminal.this.readMode && SwingTextTerminal.this.inputMasking) {
                            int caretPosition = SwingTextTerminal.this.textPane.getCaretPosition();
                            fb.replace(SwingTextTerminal.this.startReadLen, newUnmaskedInputLen, SwingTextTerminal.this.unmaskedInput, attrs);
                            textChanger.changeText(text);
                            SwingTextTerminal.this.unmaskedInput = doc.getText(SwingTextTerminal.this.startReadLen, newUnmaskedInputLen);
                            this.maskContent(fb, attrs);
                            SwingTextTerminal.this.textPane.setCaretPosition(caretPosition);
                        } else {
                            SwingTextTerminal.this.unmaskedInput = doc.getText(SwingTextTerminal.this.startReadLen, newUnmaskedInputLen);
                        }
                    }
                    catch (Exception e) {
                        logger.error("changeText failed", (Throwable)e);
                        if (e instanceof BadLocationException) {
                            throw (BadLocationException)e;
                        }
                        throw new BadLocationException(e.toString(), offset);
                    }
                    if (pos >= 0) {
                        SwingTextTerminal.this.input = SwingTextTerminal.this.unmaskedInput;
                        SwingTextTerminal.this.editLock.notifyAll();
                    }
                }
            }
        }

        private void maskContent(DocumentFilter.FilterBypass fb, AttributeSet attrs) throws BadLocationException {
            StringBuilder maskedSb = new StringBuilder();
            int maskedLen = SwingTextTerminal.this.unmaskedInput.length();
            for (int i = 0; i < maskedLen; ++i) {
                maskedSb.append('*');
            }
            fb.replace(SwingTextTerminal.this.startReadLen, maskedLen, maskedSb.toString(), attrs);
        }

        private boolean isEditAllowedAt(int offset) {
            return offset >= SwingTextTerminal.this.startReadLen;
        }
    }

    @FunctionalInterface
    private static interface TextChanger {
        public void changeText(String var1) throws BadLocationException;
    }

    private static class StyleData {
        Color color;
        Color bgColor;
        boolean bold;
        boolean italic;
        boolean underline;
        boolean strikeThrough;
        boolean subscript;
        boolean superscript;
        String fontFamily = "Courier New";
        int fontSize = 15;

        private StyleData() {
        }
    }
}

