/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.beryx.textio.ReadHandlerData;
import org.beryx.textio.TerminalProperties;

public interface TextTerminal<T extends TextTerminal<T>> {
    public String read(boolean var1);

    public void rawPrint(String var1);

    public void println();

    public TerminalProperties<T> getProperties();

    default public boolean registerUserInterruptHandler(Consumer<T> handler, boolean abortRead) {
        return false;
    }

    default public boolean bindHandler(String keyStroke, Function<T, ReadHandlerData> handler) {
        return false;
    }

    default public void init() {
    }

    default public void dispose(String resultData) {
    }

    default public void dispose() {
        this.dispose(null);
    }

    default public void abort() {
    }

    default public boolean resetLine() {
        this.println();
        return false;
    }

    default public boolean moveToLineStart() {
        this.println();
        return false;
    }

    default public boolean setBookmark(String bookmark) {
        return false;
    }

    default public boolean resetToBookmark(String bookmark) {
        this.println();
        return false;
    }

    default public void rawPrint(List<String> messages) {
        if (messages != null && !messages.isEmpty()) {
            this.rawPrint(messages.get(0));
            messages.subList(1, messages.size()).forEach(msg -> {
                this.println();
                this.print((String)msg);
            });
        }
    }

    default public void print(String message) {
        List<String> messages = Arrays.asList(message.split("\\R", -1));
        this.rawPrint(messages);
    }

    default public void println(String message) {
        this.print(message);
        this.println();
    }

    default public void print(List<String> messages) {
        if (messages == null) {
            return;
        }
        List<String> rawMessages = messages.stream().flatMap(msg -> Arrays.stream(msg.split("\\R", -1))).collect(Collectors.toList());
        this.rawPrint(rawMessages);
    }

    default public void println(List<String> messages) {
        this.print(messages);
        this.println();
    }

    default public void printf(String format, Object ... args) {
        this.print(String.format(format, args));
    }

    default public void printf(Locale l, String format, Object ... args) {
        this.print(String.format(l, format, args));
    }
}

