/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.beryx.textio.ReadAbortedException;
import org.beryx.textio.ReadInterruptionData;
import org.beryx.textio.ReadInterruptionException;
import org.beryx.textio.TerminalProperties;
import org.beryx.textio.TextTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputReader<T, B extends InputReader<T, B>> {
    private static final Logger logger = LoggerFactory.getLogger(InputReader.class);
    protected final Supplier<TextTerminal<?>> textTerminalSupplier;
    protected T defaultValue;
    protected List<T> possibleValues;
    protected boolean numberedPossibleValues = false;
    protected boolean inlinePossibleValues = false;
    protected ErrorMessagesProvider parseErrorMessagesProvider;
    protected String itemName;
    protected boolean inputMasking = false;
    protected boolean inputTrimming = true;
    protected boolean promptAdjustments = true;
    protected final List<ValueChecker<T>> valueCheckers = new ArrayList<ValueChecker<T>>();
    protected final List<ValueChecker<List<T>>> valueListCheckers = new ArrayList<ValueChecker<List<T>>>();
    protected Function<T, String> valueFormatter = String::valueOf;
    protected BiFunction<T, T, Boolean> equalsFunc = Objects::equals;
    protected Consumer<TerminalProperties<?>> propertiesConfigurator = null;
    private boolean valueListMode = false;

    protected abstract ParseResult<T> parse(String var1);

    public InputReader(Supplier<TextTerminal<?>> textTerminalSupplier) {
        this.textTerminalSupplier = textTerminalSupplier;
    }

    public B withDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return (B)this;
    }

    public B withPossibleValues(T ... possibleValues) {
        this.possibleValues = null;
        if (possibleValues.length > 0) {
            this.possibleValues = Arrays.asList(possibleValues);
        }
        return (B)this;
    }

    public B withPossibleValues(List<T> possibleValues) {
        this.possibleValues = possibleValues != null && possibleValues.isEmpty() ? null : possibleValues;
        this.numberedPossibleValues = false;
        this.inlinePossibleValues = false;
        return (B)this;
    }

    public B withNumberedPossibleValues(T ... possibleValues) {
        this.withPossibleValues(possibleValues);
        this.numberedPossibleValues = true;
        return (B)this;
    }

    public B withNumberedPossibleValues(List<T> possibleValues) {
        this.withPossibleValues(possibleValues);
        this.numberedPossibleValues = true;
        return (B)this;
    }

    public B withInlinePossibleValues(T ... possibleValues) {
        this.withPossibleValues(possibleValues);
        this.inlinePossibleValues = true;
        return (B)this;
    }

    public B withInlinePossibleValues(List<T> possibleValues) {
        this.withPossibleValues(possibleValues);
        this.inlinePossibleValues = true;
        return (B)this;
    }

    public B withInputMasking(boolean inputMasking) {
        this.inputMasking = inputMasking;
        return (B)this;
    }

    public B withInputTrimming(boolean inputTrimming) {
        this.inputTrimming = inputTrimming;
        return (B)this;
    }

    public B withPromptAdjustments(boolean promptAdjustment) {
        this.promptAdjustments = promptAdjustment;
        return (B)this;
    }

    public B withItemName(String itemName) {
        this.itemName = "".equals(itemName) ? null : itemName;
        return (B)this;
    }

    public B withValueFormatter(Function<T, String> valueFormatter) {
        this.valueFormatter = valueFormatter;
        return (B)this;
    }

    public B withEqualsFunc(BiFunction<T, T, Boolean> equalsFunc) {
        this.equalsFunc = equalsFunc;
        return (B)this;
    }

    public B withParseErrorMessagesProvider(ErrorMessagesProvider parseErrorMessagesProvider) {
        this.parseErrorMessagesProvider = parseErrorMessagesProvider;
        return (B)this;
    }

    public B withValueChecker(ValueChecker<T> valueChecker) {
        this.valueCheckers.add(valueChecker);
        return (B)this;
    }

    public B withValueListChecker(ValueChecker<List<T>> valueListChecker) {
        this.valueListCheckers.add(valueListChecker);
        return (B)this;
    }

    public B withPropertiesConfigurator(Consumer<TerminalProperties<?>> propertiesConfigurator) {
        this.propertiesConfigurator = propertiesConfigurator;
        return (B)this;
    }

    public boolean isValueListMode() {
        return this.valueListMode;
    }

    protected String getDefaultErrorMessage(String sVal) {
        StringBuilder errBuilder = new StringBuilder("Invalid value");
        if (this.valueListMode) {
            errBuilder.append(" in the comma-separated list");
            if (this.itemName != null) {
                errBuilder.append(" of '").append(this.itemName).append("'");
            }
            if (sVal != null && !sVal.isEmpty()) {
                errBuilder.append(": ").append(sVal);
            }
        } else if (this.itemName != null) {
            errBuilder.append(" for '").append(this.itemName).append("'");
        }
        errBuilder.append('.');
        return errBuilder.toString();
    }

    protected List<String> getDefaultErrorMessages(String s) {
        return new ArrayList<String>(Collections.singleton(this.getDefaultErrorMessage(s)));
    }

    protected final List<String> getErrorMessages(String s) {
        if (this.parseErrorMessagesProvider != null) {
            return this.parseErrorMessagesProvider.getErrorMessages(s, this.itemName);
        }
        return this.getDefaultErrorMessages(s);
    }

    protected ParseResult<T> parseAndCheck(String s) {
        ParseResult<Object> res = this.parse(s);
        if (((ParseResult)res).errorMessages == null) {
            ArrayList<String> allErrors = new ArrayList<String>();
            for (ValueChecker<Object> valueChecker : this.valueCheckers) {
                List<String> errors = valueChecker.getErrorMessages(((ParseResult)res).value, this.itemName);
                if (errors == null) continue;
                allErrors.addAll(errors);
            }
            if (!allErrors.isEmpty()) {
                allErrors.add(0, this.getDefaultErrorMessage(s));
                res = new ParseResult<Object>(((ParseResult)res).value, allErrors);
            }
        }
        return res;
    }

    public T read(String ... prompt) {
        return this.read(Arrays.asList(prompt));
    }

    public T read(List<String> prompt) {
        this.valueListMode = false;
        this.checkConfiguration();
        return (T)this.executeWithTerminal(textTerminal -> {
            String sVal;
            T value;
            do {
                if ((sVal = this.readWithPrompt((TextTerminal<?>)textTerminal, prompt)) != null && this.inputTrimming) {
                    sVal = sVal.trim();
                }
                if (sVal != null && !sVal.isEmpty() || this.defaultValue == null) continue;
                return this.defaultValue;
            } while ((value = this.getValueFromStringOrIndex(sVal, (TextTerminal<?>)textTerminal)) == null);
            return value;
        });
    }

    public List<T> readList(String ... prompt) {
        return this.readList(Arrays.asList(prompt));
    }

    public List<T> readList(List<String> prompt) {
        this.valueListMode = true;
        this.checkConfiguration();
        return this.executeWithTerminal(textTerminal -> {
            ArrayList<T> values;
            block0: while (true) {
                String sInput;
                String[] sValues;
                String[] stringArray = sValues = (sInput = this.readWithPrompt((TextTerminal<?>)textTerminal, prompt)) == null ? new String[]{} : sInput.split(",");
                if (this.inputTrimming) {
                    for (int i = 0; i < sValues.length; ++i) {
                        sValues[i] = sValues[i].trim();
                    }
                }
                if (sValues.length == 1 && sValues[0].isEmpty()) {
                    sValues = new String[]{};
                }
                if (sValues.length == 0 && this.defaultValue != null) {
                    return Collections.singletonList(this.defaultValue);
                }
                values = new ArrayList<T>();
                for (String sVal : sValues) {
                    T value = this.getValueFromStringOrIndex(sVal, (TextTerminal<?>)textTerminal);
                    if (value == null) continue block0;
                    values.add(value);
                }
                ArrayList<String> allErrors = new ArrayList<String>();
                for (ValueChecker checker : this.valueListCheckers) {
                    List<String> errors = checker.getErrorMessages(values, this.itemName);
                    if (errors == null) continue;
                    allErrors.addAll(errors);
                }
                if (allErrors.isEmpty()) break;
                allErrors.add(0, this.getDefaultErrorMessage(null));
                textTerminal.println(allErrors);
                textTerminal.println();
            }
            return values;
        });
    }

    protected String readWithPrompt(TextTerminal<?> textTerminal, List<String> prompt) {
        String sInput;
        this.printPrompt(prompt, textTerminal);
        block8: while (true) {
            sInput = null;
            try {
                sInput = textTerminal.read(this.inputMasking);
            }
            catch (ReadInterruptionException e) {
                ReadInterruptionData data = e.getReadInterruptionData();
                logger.debug("ReadInterruptionException with data: " + data);
                switch (data.getAction()) {
                    case CONTINUE: {
                        logger.error("ReadInterruptionException with action CONTINUE.");
                    }
                    case RESTART: {
                        if (!data.isRedrawRequired()) continue block8;
                        logger.trace("Re-printing prompt before read restart");
                        textTerminal.println();
                        this.printPrompt(prompt, textTerminal);
                        logger.trace("Prompt re-printed.");
                        continue block8;
                    }
                    case RETURN: {
                        return data.getReturnValue();
                    }
                    case ABORT: {
                        throw new ReadAbortedException(data.getPayload(), e.getPartialInput());
                    }
                }
            }
            break;
        }
        return sInput;
    }

    protected <V> V executeWithTerminal(Function<TextTerminal<?>, V> action) {
        TextTerminal<?> textTerminal = this.textTerminalSupplier.get();
        return textTerminal.applyWithPropertiesConfigurator(this.propertiesConfigurator, action);
    }

    private T getValueFromStringOrIndex(String sVal, TextTerminal<?> textTerminal) {
        if (this.possibleValues == null || !this.numberedPossibleValues) {
            return this.getValueFromString(sVal, textTerminal);
        }
        return this.getValueFromIndex(sVal, textTerminal);
    }

    private T getValueFromString(String sVal, TextTerminal<?> textTerminal) {
        ParseResult<T> result = this.parseAndCheck(sVal);
        List<String> errMessages = result.getErrorMessages();
        if (errMessages == null) {
            Optional<T> value = this.getPossibleValue(result.getValue());
            if (value.isPresent()) {
                return value.get();
            }
            textTerminal.print(this.getDefaultErrorMessage(sVal));
            if (this.inlinePossibleValues) {
                String options = this.possibleValues.stream().map(val -> "'" + this.valueFormatter.apply(val) + "'").collect(Collectors.joining(", "));
                textTerminal.println(" Please enter one of: " + options + ".");
            } else {
                textTerminal.println(" Please enter one of the displayed values.");
            }
            textTerminal.println();
        } else {
            textTerminal.println(errMessages);
            textTerminal.println();
        }
        return null;
    }

    private T getValueFromIndex(String sVal, TextTerminal<?> textTerminal) {
        try {
            int optIndex = Integer.parseInt(sVal);
            if (optIndex > 0 && optIndex <= this.possibleValues.size()) {
                return this.possibleValues.get(optIndex - 1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        textTerminal.print(this.getDefaultErrorMessage(sVal));
        textTerminal.println(" Enter a value between 1 and " + this.possibleValues.size() + ".");
        textTerminal.println();
        return null;
    }

    protected boolean isPossibleValue(T val) {
        if (this.possibleValues == null) {
            return true;
        }
        for (T pVal : this.possibleValues) {
            if (!this.equalsFunc.apply(pVal, val).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected Optional<T> getPossibleValue(T val) {
        if (this.possibleValues == null) {
            return Optional.of(val);
        }
        for (T pVal : this.possibleValues) {
            if (!this.equalsFunc.apply(pVal, val).booleanValue()) continue;
            return Optional.of(pVal);
        }
        return Optional.empty();
    }

    protected void checkConfiguration() throws IllegalArgumentException {
        if (this.defaultValue != null && !this.isPossibleValue(this.defaultValue)) {
            throw new IllegalArgumentException("Invalid default value: " + this.valueFormatter.apply(this.defaultValue) + ". Allowed values: " + this.possibleValues);
        }
        for (ValueChecker<T> checker : this.valueCheckers) {
            List<String> errors;
            if (this.defaultValue != null && (errors = checker.getErrorMessages(this.defaultValue, this.itemName)) != null) {
                throw new IllegalArgumentException("Invalid default value: " + this.valueFormatter.apply(this.defaultValue) + ".\n" + errors);
            }
            if (this.possibleValues == null) continue;
            for (T val : this.possibleValues) {
                errors = checker.getErrorMessages(val, this.itemName);
                if (errors == null) continue;
                throw new IllegalArgumentException("Invalid entry in the list of possible values: " + this.valueFormatter.apply(val) + ".\n" + errors);
            }
        }
    }

    protected void printPrompt(List<String> prompt, TextTerminal<?> textTerminal) {
        textTerminal.print(prompt);
        boolean useColon = false;
        if (this.promptAdjustments && prompt != null && !prompt.isEmpty()) {
            String lastLine = prompt.get(prompt.size() - 1);
            useColon = InputReader.shouldappendColon(lastLine);
        }
        if (this.possibleValues == null) {
            if (this.promptAdjustments && this.defaultValue != null) {
                textTerminal.print(" [" + this.valueFormatter.apply(this.defaultValue) + "]: ");
            } else {
                textTerminal.print(useColon ? ": " : " ");
            }
        } else if (this.promptAdjustments) {
            int optionCount = this.possibleValues.size();
            if (this.inlinePossibleValues) {
                String sValues = IntStream.range(0, optionCount).mapToObj(i -> this.possibleValues.get(i)).map(option -> {
                    boolean isDefault = this.defaultValue != null && this.equalsFunc.apply(this.defaultValue, option) != false;
                    return (isDefault ? "*" : "") + this.valueFormatter.apply(option);
                }).collect(Collectors.joining(", ", " (", "): "));
                textTerminal.print(sValues);
            } else {
                textTerminal.println(useColon ? ":" : "");
                for (int i2 = 0; i2 < optionCount; ++i2) {
                    T option2 = this.possibleValues.get(i2);
                    boolean isDefault = this.defaultValue != null && this.equalsFunc.apply(this.defaultValue, option2) != false;
                    String optionId = "";
                    String optionText = this.valueFormatter.apply(option2);
                    if (this.numberedPossibleValues) {
                        int digits = ("" + optionCount).length();
                        optionId = String.format("%" + digits + "d: ", i2 + 1);
                        String[] textLines = optionText.split("\\R", -1);
                        if (textLines.length > 1) {
                            String delimiter = String.format("\n%" + (digits + 4) + "s", "");
                            optionText = Arrays.stream(textLines).collect(Collectors.joining(delimiter));
                        }
                    }
                    textTerminal.println((isDefault ? "* " : "  ") + optionId + optionText);
                }
                textTerminal.print(this.valueListMode ? "Enter your choices as comma-separated values: " : "Enter your choice: ");
            }
        }
    }

    private static boolean shouldappendColon(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        char lastChar = s.charAt(s.length() - 1);
        return "()[]{}".indexOf(lastChar) > 0 || Character.isJavaIdentifierPart(lastChar);
    }

    public static <T> ValueChecker<List<T>> nonEmptyListChecker() {
        return (list, propName) -> {
            if (list == null || list.isEmpty()) {
                return Collections.singletonList("Expected at least one element.");
            }
            return null;
        };
    }

    public static <T> ValueChecker<List<T>> noDuplicatesChecker() {
        return (list, propName) -> {
            if (list == null || list.size() < 2) {
                return null;
            }
            HashSet valueSet = new HashSet(list);
            if (valueSet.size() < list.size()) {
                return Collections.singletonList("Duplicate values are not allowed.");
            }
            return null;
        };
    }

    public static class ParseResult<T> {
        private final T value;
        private final List<String> errorMessages;

        public ParseResult(T value) {
            this.value = value;
            this.errorMessages = null;
        }

        public ParseResult(T value, List<String> errorMessages) {
            this.value = value;
            this.errorMessages = errorMessages != null && errorMessages.isEmpty() ? null : errorMessages;
        }

        public ParseResult(T value, String ... errorMessages) {
            this.value = value;
            this.errorMessages = errorMessages.length == 0 ? null : Arrays.asList(errorMessages);
        }

        public T getValue() {
            return this.value;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }
    }

    @FunctionalInterface
    public static interface ValueChecker<T> {
        public List<String> getErrorMessages(T var1, String var2);
    }

    @FunctionalInterface
    public static interface ErrorMessagesProvider {
        public List<String> getErrorMessages(String var1, String var2);
    }
}

