/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.textio;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.paint.Color;
import org.beryx.textio.TextTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalProperties<T extends TextTerminal<T>> {
    private static final Logger logger = LoggerFactory.getLogger(TerminalProperties.class);
    private final T textTerminal;
    private final Map<String, String> props = new HashMap<String, String>();
    private final List<ExtendedChangeListener<T>> listeners = new ArrayList<ExtendedChangeListener<T>>();

    public TerminalProperties(T textTerminal) {
        this.textTerminal = textTerminal;
    }

    public List<ExtendedChangeListener<T>> getListeners() {
        return this.listeners;
    }

    public Object remove(String key) {
        if (key == null) {
            return null;
        }
        String oldVal = this.props.remove(key);
        this.listeners.forEach(listener -> listener.changed(this.textTerminal, key, oldVal, null));
        return oldVal;
    }

    public Object put(String key, Object value) {
        if (key == null) {
            return null;
        }
        String newVal = value == null ? null : String.valueOf(value);
        String oldVal = this.props.put(key, newVal);
        this.listeners.forEach(listener -> listener.changed(this.textTerminal, key, oldVal, newVal));
        return oldVal;
    }

    public void putAll(Map<String, ? extends Object> map) {
        if (map == null) {
            return;
        }
        map.entrySet().forEach(entry -> this.put((String)entry.getKey(), entry.getValue()));
    }

    public Set<String> getAllKeys() {
        return this.props.keySet();
    }

    public Set<String> getMatchingKeys(String regex) {
        return this.getMatchingKeys((String key) -> key.matches(regex));
    }

    public Set<String> getMatchingKeys(Predicate<String> keyFilter) {
        return this.props.keySet().stream().filter(keyFilter).collect(Collectors.toSet());
    }

    public String getString(String key) {
        return this.props.get(key);
    }

    public String getString(String key, String defaultValue) {
        String value = this.props.get(key);
        if (value == null || value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    public int getInt(String key, int defaultValue) {
        String sVal = this.props.get(key);
        if (sVal == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sVal);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getLong(String key, long defaultValue) {
        String sVal = this.props.get(key);
        if (sVal == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sVal);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getDouble(String key, double defaultValue) {
        String sVal = this.props.get(key);
        if (sVal == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sVal);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String sVal = this.props.get(key);
        if (sVal == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(sVal);
    }

    public void addListener(ExtendedChangeListener<T> listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(ExtendedChangeListener<T> listener) {
        return this.listeners.remove(listener);
    }

    public void addStringListener(String key, String defaultValue, StringChangeListener<T> listener) {
        this.listeners.add(new ChangeListenerForKey(key, defaultValue, Function.identity(), listener.get()));
    }

    public void addIntListener(String key, int defaultValue, IntChangeListener<T> listener) {
        this.listeners.add(new ChangeListenerForKey(key, defaultValue, Integer::parseInt, listener.get()));
    }

    public void addLongListener(String key, long defaultValue, LongChangeListener<T> listener) {
        this.listeners.add(new ChangeListenerForKey(key, defaultValue, Long::parseLong, listener.get()));
    }

    public void addDoubleListener(String key, double defaultValue, DoubleChangeListener<T> listener) {
        this.listeners.add(new ChangeListenerForKey(key, defaultValue, Double::parseDouble, listener.get()));
    }

    public void addBooleanListener(String key, boolean defaultValue, BooleanChangeListener<T> listener) {
        this.listeners.add(new ChangeListenerForKey(key, defaultValue, Boolean::parseBoolean, listener.get()));
    }

    private static String toHex(Color color) {
        int r = (int)Math.round(color.getRed() * 255.0);
        int g = (int)Math.round(color.getGreen() * 255.0);
        int b = (int)Math.round(color.getBlue() * 255.0);
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public void setPromptColor(String color) {
        this.put("prompt.color", color);
    }

    public void setPromptColor(Color color) {
        this.put("prompt.color", TerminalProperties.toHex(color));
    }

    public void setPromptBackgroundColor(String bgcolor) {
        this.put("prompt.bgcolor", bgcolor);
    }

    public void setPromptBackgroundColor(Color bgcolor) {
        this.put("prompt.bgcolor", TerminalProperties.toHex(bgcolor));
    }

    public void setPromptBold(boolean bold) {
        this.put("prompt.bold", bold);
    }

    public void setPromptItalic(boolean italic) {
        this.put("prompt.italic", italic);
    }

    public void setPromptUnderline(boolean underline) {
        this.put("prompt.underline", underline);
    }

    public void setInputColor(String color) {
        this.put("input.color", color);
    }

    public void setInputColor(Color color) {
        this.put("input.color", TerminalProperties.toHex(color));
    }

    public void setInputBackgroundColor(String bgcolor) {
        this.put("input.bgcolor", bgcolor);
    }

    public void setInputBackgroundColor(Color bgcolor) {
        this.put("input.bgcolor", TerminalProperties.toHex(bgcolor));
    }

    public void setInputBold(boolean bold) {
        this.put("input.bold", bold);
    }

    public void setInputItalic(boolean italic) {
        this.put("input.italic", italic);
    }

    public void setInputUnderline(boolean underline) {
        this.put("input.underline", underline);
    }

    public void setPaneBackgroundColor(String bgcolor) {
        this.put("pane.bgcolor", bgcolor);
    }

    public void setPaneBackgroundColor(Color bgcolor) {
        this.put("pane.bgcolor", TerminalProperties.toHex(bgcolor));
    }

    public void setPaneWidth(int width) {
        this.put("pane.width", width);
    }

    public void setPaneHeight(int height) {
        this.put("pane.height", height);
    }

    public void setPaneDimension(int width, int height) {
        this.put("pane.width", width);
        this.put("pane.height", height);
    }

    private static class ChangeListenerForKey<TT extends TextTerminal<TT>, V>
    implements ExtendedChangeListener<TT> {
        private final String key;
        private final V defaultValue;
        private final Function<String, V> valueConverter;
        private final ChangeListener<TT, V> delegate;

        private ChangeListenerForKey(String key, V defaultValue, Function<String, V> valueConverter, ChangeListener<TT, V> delegate) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.valueConverter = valueConverter;
            this.delegate = delegate;
        }

        @Override
        public void changed(TT textTerminal, String changedKey, String sOldVal, String sNewVal) {
            if (changedKey.equals(this.key)) {
                V newVal = this.defaultValue;
                if (sNewVal != null) {
                    try {
                        newVal = this.valueConverter.apply(sNewVal);
                    }
                    catch (Exception e) {
                        logger.warn("Invalid value for property " + changedKey + ": " + sNewVal, (Throwable)e);
                        newVal = this.defaultValue;
                    }
                }
                this.delegate.changed(textTerminal, newVal);
            }
        }
    }

    @FunctionalInterface
    public static interface ExtendedChangeListener<TT extends TextTerminal<TT>> {
        public void changed(TT var1, String var2, String var3, String var4);
    }

    @FunctionalInterface
    public static interface BooleanChangeListener<TT extends TextTerminal<TT>> {
        public void changed(TT var1, Boolean var2);

        default public ChangeListener<TT, Boolean> get() {
            return (term, newVal) -> this.changed((TT)term, (Boolean)newVal);
        }
    }

    @FunctionalInterface
    public static interface DoubleChangeListener<TT extends TextTerminal<TT>> {
        public void changed(TT var1, Double var2);

        default public ChangeListener<TT, Double> get() {
            return (term, newVal) -> this.changed((TT)term, (Double)newVal);
        }
    }

    @FunctionalInterface
    public static interface LongChangeListener<TT extends TextTerminal<TT>> {
        public void changed(TT var1, Long var2);

        default public ChangeListener<TT, Long> get() {
            return (term, newVal) -> this.changed((TT)term, (Long)newVal);
        }
    }

    @FunctionalInterface
    public static interface IntChangeListener<TT extends TextTerminal<TT>> {
        public void changed(TT var1, Integer var2);

        default public ChangeListener<TT, Integer> get() {
            return (term, newVal) -> this.changed((TT)term, (Integer)newVal);
        }
    }

    @FunctionalInterface
    public static interface StringChangeListener<TT extends TextTerminal<TT>> {
        public void changed(TT var1, String var2);

        default public ChangeListener<TT, String> get() {
            return (term, newVal) -> this.changed((TT)term, (String)newVal);
        }
    }

    public static interface ChangeListener<TT extends TextTerminal<TT>, V> {
        public void changed(TT var1, V var2);
    }
}

