/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core;

import java.io.Serializable;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;

public class Connection
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Neuron fromNeuron;
    protected Neuron toNeuron;
    protected Weight weight;

    public Connection(Neuron fromNeuron, Neuron toNeuron) {
        if (fromNeuron == null) {
            throw new IllegalArgumentException("From neuron in connection cant be null !");
        }
        this.fromNeuron = fromNeuron;
        if (toNeuron == null) {
            throw new IllegalArgumentException("To neuron in connection cant be null!");
        }
        this.toNeuron = toNeuron;
        this.weight = new Weight();
    }

    public Connection(Neuron fromNeuron, Neuron toNeuron, Weight weight) {
        if (fromNeuron == null) {
            throw new IllegalArgumentException("From neuron in connection cant be null !");
        }
        this.fromNeuron = fromNeuron;
        if (toNeuron == null) {
            throw new IllegalArgumentException("To neuron in connection cant be null!");
        }
        this.toNeuron = toNeuron;
        if (weight == null) {
            throw new IllegalArgumentException("Connection Weight cant be null!");
        }
        this.weight = weight;
    }

    public Connection(Neuron fromNeuron, Neuron toNeuron, double weightVal) {
        if (fromNeuron == null) {
            throw new IllegalArgumentException("From neuron in connection cant be null !");
        }
        this.fromNeuron = fromNeuron;
        if (toNeuron == null) {
            throw new IllegalArgumentException("To neuron in connection cant be null!");
        }
        this.toNeuron = toNeuron;
        this.weight = new Weight(weightVal);
    }

    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        if (weight == null) {
            throw new IllegalArgumentException("Connection Weight cant be null!");
        }
        this.weight = weight;
    }

    public double getInput() {
        return this.fromNeuron.getOutput();
    }

    public double getWeightedInput() {
        return this.fromNeuron.getOutput() * this.weight.value;
    }

    public Neuron getFromNeuron() {
        return this.fromNeuron;
    }

    public void setFromNeuron(Neuron fromNeuron) {
        if (fromNeuron == null) {
            throw new IllegalArgumentException("From neuron in connection cant be null!");
        }
        this.fromNeuron = fromNeuron;
    }

    public Neuron getToNeuron() {
        return this.toNeuron;
    }

    public void setToNeuron(Neuron toNeuron) {
        if (toNeuron == null) {
            throw new IllegalArgumentException("From neuron in connection cant be null!");
        }
        this.toNeuron = toNeuron;
    }
}

