/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.transfer;

import java.io.Serializable;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.util.Properties;

public class Linear
extends TransferFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double slope = 1.0;

    public Linear() {
    }

    public Linear(double slope) {
        this.slope = slope;
    }

    public Linear(Properties properties) {
        try {
            this.slope = (Double)properties.getProperty("transferFunction.slope");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid transfer function properties! Using default values.");
        }
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    @Override
    public double getOutput(double net) {
        return this.slope * net;
    }

    @Override
    public double getDerivative(double net) {
        return this.slope;
    }
}

